/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.persistence.deploy;

import java.util.List;
import java.util.Map;
import org.flowable.dmn.api.DecisionTable;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.DecisionTableQueryImpl;
import org.flowable.dmn.engine.impl.persistence.deploy.DecisionTableCacheEntry;
import org.flowable.dmn.engine.impl.persistence.deploy.Deployer;
import org.flowable.dmn.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.ResourceEntity;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;

public class DeploymentManager {
    protected DmnEngineConfiguration engineConfig;
    protected DeploymentCache<DecisionTableCacheEntry> decisionCache;
    protected List<Deployer> deployers;
    protected DecisionTableEntityManager decisionTableEntityManager;
    protected DmnDeploymentEntityManager deploymentEntityManager;

    public DeploymentManager(DeploymentCache<DecisionTableCacheEntry> decisionCache, DmnEngineConfiguration engineConfig) {
        this.decisionCache = decisionCache;
        this.engineConfig = engineConfig;
    }

    public void deploy(DmnDeploymentEntity deployment) {
        this.deploy(deployment, null);
    }

    public void deploy(DmnDeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        for (Deployer deployer : this.deployers) {
            deployer.deploy(deployment, deploymentSettings);
        }
    }

    public DecisionTableEntity findDeployedDecisionById(String decisionId) {
        DecisionTableEntity decisionTable;
        if (decisionId == null) {
            throw new FlowableException("Invalid decision id : null");
        }
        DecisionTableCacheEntry cacheEntry = this.decisionCache.get(decisionId);
        DecisionTableEntity decisionTableEntity = decisionTable = cacheEntry != null ? cacheEntry.getDecisionTableEntity() : null;
        if (decisionTable == null) {
            decisionTable = (DecisionTableEntity)this.engineConfig.getDecisionTableEntityManager().findById(decisionId);
            if (decisionTable == null) {
                throw new FlowableObjectNotFoundException("no deployed decision found with id '" + decisionId + "'");
            }
            decisionTable = this.resolveDecisionTable(decisionTable).getDecisionTableEntity();
        }
        return decisionTable;
    }

    public DecisionTableEntity findDeployedLatestDecisionByKey(String decisionKey) {
        DecisionTableEntity decisionTable = this.decisionTableEntityManager.findLatestDecisionTableByKey(decisionKey);
        if (decisionTable == null) {
            throw new FlowableObjectNotFoundException("no decisions deployed with key '" + decisionKey + "'");
        }
        decisionTable = this.resolveDecisionTable(decisionTable).getDecisionTableEntity();
        return decisionTable;
    }

    public DecisionTableEntity findDeployedLatestDecisionByKeyAndTenantId(String decisionKey, String tenantId) {
        DecisionTableEntity decisionTable = this.decisionTableEntityManager.findLatestDecisionTableByKeyAndTenantId(decisionKey, tenantId);
        if (decisionTable == null) {
            throw new FlowableObjectNotFoundException("no decisions deployed with key '" + decisionKey + "' for tenant identifier '" + tenantId + "'");
        }
        decisionTable = this.resolveDecisionTable(decisionTable).getDecisionTableEntity();
        return decisionTable;
    }

    public DecisionTableEntity findDeployedLatestDecisionByKeyAndParentDeploymentId(String decisionTableKey, String parentDeploymentId) {
        DecisionTableEntity decisionTable = this.decisionTableEntityManager.findLatestDecisionTableByKeyAndParentDeploymentId(decisionTableKey, parentDeploymentId);
        if (decisionTable == null) {
            throw new FlowableObjectNotFoundException("no decisions deployed with key '" + decisionTableKey + "' for parent deployment id '" + parentDeploymentId + "'");
        }
        decisionTable = this.resolveDecisionTable(decisionTable).getDecisionTableEntity();
        return decisionTable;
    }

    public DecisionTableEntity findDeployedLatestDecisionByKeyParentDeploymentIdAndTenantId(String decisionTableKey, String parentDeploymentId, String tenantId) {
        DecisionTableEntity decisionTable = this.decisionTableEntityManager.findLatestDecisionTableByKeyParentDeploymentIdAndTenantId(decisionTableKey, parentDeploymentId, tenantId);
        if (decisionTable == null) {
            throw new FlowableObjectNotFoundException("no decisions deployed with key '" + decisionTableKey + "' for parent deployment id '" + parentDeploymentId + "' and tenant identifier " + tenantId);
        }
        decisionTable = this.resolveDecisionTable(decisionTable).getDecisionTableEntity();
        return decisionTable;
    }

    public DecisionTableEntity findDeployedDecisionByKeyAndVersionAndTenantId(String decisionKey, int decisionVersion, String tenantId) {
        DecisionTableEntity decisionTable = this.decisionTableEntityManager.findDecisionTableByKeyAndVersionAndTenantId(decisionKey, decisionVersion, tenantId);
        if (decisionTable == null) {
            throw new FlowableObjectNotFoundException("no decisions deployed with key = '" + decisionKey + "' and version = '" + decisionVersion + "'");
        }
        decisionTable = this.resolveDecisionTable(decisionTable).getDecisionTableEntity();
        return decisionTable;
    }

    public DecisionTableCacheEntry resolveDecisionTable(DecisionTable decision) {
        String decisionId = decision.getId();
        String deploymentId = decision.getDeploymentId();
        DecisionTableCacheEntry cachedDecision = this.decisionCache.get(decisionId);
        if (cachedDecision == null) {
            DmnDeploymentEntity deployment = (DmnDeploymentEntity)this.engineConfig.getDeploymentEntityManager().findById(deploymentId);
            List<ResourceEntity> resources = this.engineConfig.getResourceEntityManager().findResourcesByDeploymentId(deploymentId);
            for (ResourceEntity resource : resources) {
                deployment.addResource(resource);
            }
            deployment.setNew(false);
            this.deploy(deployment, null);
            cachedDecision = this.decisionCache.get(decisionId);
            if (cachedDecision == null) {
                throw new FlowableException("deployment '" + deploymentId + "' didn't put decision '" + decisionId + "' in the cache");
            }
        }
        return cachedDecision;
    }

    public void removeDeployment(String deploymentId) {
        DmnDeploymentEntity deployment = (DmnDeploymentEntity)this.deploymentEntityManager.findById(deploymentId);
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.");
        }
        List decisionTables = new DecisionTableQueryImpl().deploymentId(deploymentId).list();
        this.deploymentEntityManager.deleteDeployment(deploymentId);
        for (DecisionTable decisionTable : decisionTables) {
            this.decisionCache.remove(decisionTable.getId());
        }
    }

    public List<Deployer> getDeployers() {
        return this.deployers;
    }

    public void setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
    }

    public DeploymentCache<DecisionTableCacheEntry> getDecisionCache() {
        return this.decisionCache;
    }

    public void setDecisionCache(DeploymentCache<DecisionTableCacheEntry> decisionCache) {
        this.decisionCache = decisionCache;
    }

    public DecisionTableEntityManager getDecisionTableEntityManager() {
        return this.decisionTableEntityManager;
    }

    public void setDecisionTableEntityManager(DecisionTableEntityManager decisionTableEntityManager) {
        this.decisionTableEntityManager = decisionTableEntityManager;
    }

    public DmnDeploymentEntityManager getDeploymentEntityManager() {
        return this.deploymentEntityManager;
    }

    public void setDeploymentEntityManager(DmnDeploymentEntityManager deploymentEntityManager) {
        this.deploymentEntityManager = deploymentEntityManager;
    }
}

