/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.mvel.config;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.flowable.dmn.engine.CustomExpressionFunctionRegistry;
import org.flowable.dmn.engine.impl.mvel.extension.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCustomExpressionFunctionRegistry
implements CustomExpressionFunctionRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCustomExpressionFunctionRegistry.class);
    protected static Map<String, Method> customFunctionConfigurations = new HashMap<String, Method>();

    @Override
    public Map<String, Method> getCustomExpressionMethods() {
        return customFunctionConfigurations;
    }

    protected static void addCustomFunction(String methodName, Method methodRef) {
        customFunctionConfigurations.put(methodName, methodRef);
    }

    protected static Method getMethod(Class classRef, String methodName, Class ... methodParam) {
        try {
            logger.debug("adding method to MVEL: {} {} with {} parameters", new Object[]{classRef.getName(), methodName, methodParam.length});
            return classRef.getMethod(methodName, methodParam);
        }
        catch (NoSuchMethodException nsme) {
            logger.error("Could not find method for name: " + methodName, (Throwable)nsme);
            return null;
        }
    }

    static {
        DefaultCustomExpressionFunctionRegistry.addCustomFunction("fn_date", DefaultCustomExpressionFunctionRegistry.getMethod(DateUtil.class, "toDate", String.class));
        DefaultCustomExpressionFunctionRegistry.addCustomFunction("fn_addDate", DefaultCustomExpressionFunctionRegistry.getMethod(DateUtil.class, "addDate", Date.class, Integer.class, Integer.class, Integer.class));
        DefaultCustomExpressionFunctionRegistry.addCustomFunction("fn_subtractDate", DefaultCustomExpressionFunctionRegistry.getMethod(DateUtil.class, "subtractDate", Date.class, Integer.class, Integer.class, Integer.class));
        DefaultCustomExpressionFunctionRegistry.addCustomFunction("fn_now", DefaultCustomExpressionFunctionRegistry.getMethod(DateUtil.class, "getCurrentDate", new Class[0]));
    }
}

