/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.deployer;

import java.util.List;
import java.util.Map;
import org.flowable.dmn.engine.impl.parser.DmnParse;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.persistence.entity.ResourceEntity;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DmnDefinition;

public class ParsedDeployment {
    protected DmnDeploymentEntity deploymentEntity;
    protected List<DecisionTableEntity> decisionTables;
    protected Map<DecisionTableEntity, DmnParse> mapDecisionTablesToParses;
    protected Map<DecisionTableEntity, ResourceEntity> mapDecisionTablesToResources;

    public ParsedDeployment(DmnDeploymentEntity entity, List<DecisionTableEntity> decisionTables, Map<DecisionTableEntity, DmnParse> mapDecisionTablesToParses, Map<DecisionTableEntity, ResourceEntity> mapDecisionTablesToResources) {
        this.deploymentEntity = entity;
        this.decisionTables = decisionTables;
        this.mapDecisionTablesToParses = mapDecisionTablesToParses;
        this.mapDecisionTablesToResources = mapDecisionTablesToResources;
    }

    public DmnDeploymentEntity getDeployment() {
        return this.deploymentEntity;
    }

    public List<DecisionTableEntity> getAllDecisionTables() {
        return this.decisionTables;
    }

    public ResourceEntity getResourceForDecisionTable(DecisionTableEntity decisionTable) {
        return this.mapDecisionTablesToResources.get(decisionTable);
    }

    public DmnParse getDmnParseForDecisionTable(DecisionTableEntity decisionTable) {
        return this.mapDecisionTablesToParses.get(decisionTable);
    }

    public DmnDefinition getDmnDefinitionForDecisionTable(DecisionTableEntity decisionTable) {
        DmnParse parse = this.getDmnParseForDecisionTable(decisionTable);
        return parse == null ? null : parse.getDmnDefinition();
    }

    public Decision getDecisionForDecisionTable(DecisionTableEntity decisionTable) {
        DmnDefinition dmnDefinition = this.getDmnDefinitionForDecisionTable(decisionTable);
        return dmnDefinition == null ? null : dmnDefinition.getDrgElementById(decisionTable.getKey());
    }
}

