/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.dmn.api.DecisionTable;
import org.flowable.dmn.engine.impl.DecisionTableQueryImpl;
import org.flowable.dmn.engine.impl.interceptor.Command;
import org.flowable.dmn.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;

public class SetDeploymentTenantIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String newTenantId;

    public SetDeploymentTenantIdCmd(String deploymentId, String newTenantId) {
        this.deploymentId = deploymentId;
        this.newTenantId = newTenantId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new FlowableIllegalArgumentException("deploymentId is null");
        }
        DmnDeploymentEntity deployment = (DmnDeploymentEntity)commandContext.getDeploymentEntityManager().findById(this.deploymentId);
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find deployment with id " + this.deploymentId);
        }
        deployment.setTenantId(this.newTenantId);
        commandContext.getDecisionTableEntityManager().updateDecisionTableTenantIdForDeployment(this.deploymentId, this.newTenantId);
        List decisionTables = new DecisionTableQueryImpl().deploymentId(this.deploymentId).list();
        for (DecisionTable decisionTable : decisionTables) {
            commandContext.getDmnEngineConfiguration().getDecisionCache().remove(decisionTable.getId());
        }
        commandContext.getDeploymentEntityManager().update(deployment);
        return null;
    }
}

