/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.api.RuleEngineExecutionResult;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.interceptor.Command;
import org.flowable.dmn.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.engine.impl.persistence.deploy.DecisionTableCacheEntry;
import org.flowable.dmn.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;

public class ExecuteDecisionCmd
implements Command<RuleEngineExecutionResult>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String decisionKey;
    protected String parentDeploymentId;
    protected Map<String, Object> variables;
    protected String tenantId;

    public ExecuteDecisionCmd(String decisionKey, Map<String, Object> variables) {
        this.decisionKey = decisionKey;
        this.variables = variables;
    }

    public ExecuteDecisionCmd(String decisionKey, String parentDeploymentId, Map<String, Object> variables) {
        this(decisionKey, variables);
        this.parentDeploymentId = parentDeploymentId;
    }

    public ExecuteDecisionCmd(String decisionKey, String parentDeploymentId, Map<String, Object> variables, String tenantId) {
        this(decisionKey, parentDeploymentId, variables);
        this.tenantId = tenantId;
    }

    @Override
    public RuleEngineExecutionResult execute(CommandContext commandContext) {
        if (this.decisionKey == null) {
            throw new FlowableIllegalArgumentException("decisionKey is null");
        }
        DmnEngineConfiguration dmnEngineConfiguration = commandContext.getDmnEngineConfiguration();
        DeploymentManager deploymentManager = dmnEngineConfiguration.getDeploymentManager();
        DecisionTableEntity decisionTable = null;
        if (StringUtils.isNotEmpty((CharSequence)this.decisionKey) && StringUtils.isNotEmpty((CharSequence)this.parentDeploymentId) && StringUtils.isNotEmpty((CharSequence)this.tenantId)) {
            decisionTable = deploymentManager.findDeployedLatestDecisionByKeyParentDeploymentIdAndTenantId(this.decisionKey, this.parentDeploymentId, this.tenantId);
            if (decisionTable == null) {
                throw new FlowableObjectNotFoundException("No decision found for key: " + this.decisionKey + ", parent deployment id " + this.parentDeploymentId + " and tenant id: " + this.tenantId);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)this.decisionKey) && StringUtils.isNotEmpty((CharSequence)this.parentDeploymentId)) {
            decisionTable = deploymentManager.findDeployedLatestDecisionByKeyAndParentDeploymentId(this.decisionKey, this.parentDeploymentId);
            if (decisionTable == null) {
                throw new FlowableObjectNotFoundException("No decision found for key: " + this.decisionKey + " and parent deployment id " + this.parentDeploymentId);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)this.decisionKey) && StringUtils.isNotEmpty((CharSequence)this.tenantId)) {
            decisionTable = deploymentManager.findDeployedLatestDecisionByKeyAndTenantId(this.decisionKey, this.tenantId);
            if (decisionTable == null) {
                throw new FlowableObjectNotFoundException("No decision found for key: " + this.decisionKey + " and tenant id " + this.tenantId);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)this.decisionKey)) {
            decisionTable = deploymentManager.findDeployedLatestDecisionByKey(this.decisionKey);
            if (decisionTable == null) {
                throw new FlowableObjectNotFoundException("No decision found for key: " + this.decisionKey);
            }
        } else {
            throw new IllegalArgumentException("decisionKey is null");
        }
        DecisionTableCacheEntry decisionTableCacheEntry = deploymentManager.resolveDecisionTable(decisionTable);
        DmnDefinition dmnDefinition = decisionTableCacheEntry.getDmnDefinition();
        RuleEngineExecutionResult executionResult = dmnEngineConfiguration.getRuleEngineExecutor().execute(dmnDefinition, this.variables, dmnEngineConfiguration.getCustomExpressionFunctions(), dmnEngineConfiguration.getCustomPropertyHandlers());
        if (executionResult != null && executionResult.getAuditTrail() != null) {
            executionResult.getAuditTrail().setDmnDeploymentId(decisionTable.getDeploymentId());
        }
        return executionResult;
    }
}

