/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.audit;

import java.util.Map;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DmnDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionExecutionAuditUtil {
    private static final Logger logger = LoggerFactory.getLogger(DecisionExecutionAuditUtil.class);

    public static DecisionExecutionAuditContainer initializeRuleExecutionAudit(DmnDefinition definition, Map<String, Object> inputVariables) {
        if (definition == null || definition.getDrgElements() == null || definition.getDrgElements().get(0) == null || ((Decision)definition.getDrgElements().get(0)).getId() == null) {
            logger.error("DMN definition does not contain decision key");
            throw new IllegalArgumentException("DMN definition does not contain decision key");
        }
        if (definition.getCurrentDecisionTable().getHitPolicy() == null) {
            logger.error("decision table does not contain a hit policy");
            throw new IllegalArgumentException("decision table does not contain a hit policy");
        }
        String definitionKey = ((Decision)definition.getDrgElements().get(0)).getId();
        String definitionName = ((Decision)definition.getDrgElements().get(0)).getName();
        return new DecisionExecutionAuditContainer(definitionKey, definitionName, definition.getCurrentDecisionTable().getHitPolicy(), inputVariables);
    }
}

