/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.api.RuleEngineExecutionResult;
import org.flowable.dmn.engine.FlowableDmnExpressionException;
import org.flowable.dmn.engine.RuleEngineExecutor;
import org.flowable.dmn.engine.impl.ValidRuleOutputEntries;
import org.flowable.dmn.engine.impl.mvel.ExecutionVariableFactory;
import org.flowable.dmn.engine.impl.mvel.MvelExecutionContext;
import org.flowable.dmn.engine.impl.mvel.MvelExecutionContextBuilder;
import org.flowable.dmn.engine.impl.mvel.MvelExpressionExecutor;
import org.flowable.dmn.model.DecisionRule;
import org.flowable.dmn.model.DecisionTable;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.model.HitPolicy;
import org.flowable.dmn.model.LiteralExpression;
import org.flowable.dmn.model.RuleInputClauseContainer;
import org.flowable.dmn.model.RuleOutputClauseContainer;
import org.flowable.engine.common.api.FlowableException;
import org.mvel2.integration.PropertyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEngineExecutorImpl
implements RuleEngineExecutor {
    private static final Logger logger = LoggerFactory.getLogger(RuleEngineExecutorImpl.class);

    @Override
    public RuleEngineExecutionResult execute(DmnDefinition decisionDefinition, Map<String, Object> executionVariables, Map<String, Method> customExpressionFunctions, Map<Class<?>, PropertyHandler> propertyHandlers) {
        if (decisionDefinition == null) {
            throw new IllegalArgumentException("no decision provided");
        }
        if (decisionDefinition.getCurrentDecisionTable() == null) {
            throw new IllegalArgumentException("no decision table present in definition");
        }
        MvelExecutionContext executionContext = MvelExecutionContextBuilder.build(decisionDefinition, executionVariables, customExpressionFunctions, propertyHandlers);
        Map<String, Object> resultVariables = this.evaluateDecisionTable(decisionDefinition.getCurrentDecisionTable(), executionContext);
        executionContext.getAuditContainer().stopAudit(resultVariables);
        RuleEngineExecutionResult executionResult = new RuleEngineExecutionResult(resultVariables, executionContext.getAuditContainer());
        return executionResult;
    }

    protected Map<String, Object> evaluateDecisionTable(DecisionTable decisionTable, MvelExecutionContext executionContext) {
        if (decisionTable == null || decisionTable.getRules().isEmpty()) {
            throw new IllegalArgumentException("no rules present in table");
        }
        if (executionContext == null) {
            throw new FlowableException("no execution context available");
        }
        logger.debug("Start table evaluation: {}", (Object)decisionTable.getId());
        HashMap ruleResults = new HashMap();
        ArrayList<ValidRuleOutputEntries> validConclusionsStack = new ArrayList<ValidRuleOutputEntries>();
        int ruleRowCounter = 0;
        try {
            for (DecisionRule rule : decisionTable.getRules()) {
                Boolean ruleResult = this.executeRule(ruleRowCounter, rule, executionContext, validConclusionsStack);
                if (this.shouldContinueEvaluating(decisionTable.getHitPolicy(), ruleResult).booleanValue()) {
                    ++ruleRowCounter;
                    continue;
                }
                break;
            }
        }
        catch (FlowableException ade) {
            logger.error("decision table execution failed", (Throwable)ade);
            executionContext.getAuditContainer().setFailed();
            executionContext.getAuditContainer().setExceptionMessage(this.getExceptionMessage((Exception)((Object)ade)));
        }
        logger.debug("End table evaluation: {}", (Object)decisionTable.getId());
        return executionContext.getResultVariables();
    }

    protected Boolean shouldContinueEvaluating(HitPolicy hitPolicy, Boolean ruleResult) {
        Boolean shouldContinue = Boolean.TRUE;
        if (hitPolicy == HitPolicy.FIRST && ruleResult.booleanValue()) {
            logger.debug("Stopping execution: rule is valid and Hit Policy is FIRST");
            shouldContinue = Boolean.FALSE;
        }
        return shouldContinue;
    }

    protected Boolean executeRule(int ruleRowIndex, DecisionRule rule, MvelExecutionContext executionContext, List<ValidRuleOutputEntries> validOutputEntriesStack) {
        if (rule == null) {
            throw new FlowableException("rule cannot be null");
        }
        logger.debug("Start rule evaluation");
        executionContext.getAuditContainer().addRuleEntry();
        Boolean conditionResult = Boolean.FALSE;
        for (RuleInputClauseContainer conditionContainer : rule.getInputEntries()) {
            conditionResult = Boolean.FALSE;
            try {
                conditionResult = StringUtils.isEmpty((CharSequence)conditionContainer.getInputEntry().getText()) ? Boolean.TRUE : this.executeInputExpressionEvaluation(conditionContainer, executionContext);
                executionContext.getAuditContainer().addInputEntry(ruleRowIndex, conditionContainer.getInputEntry().getId(), conditionResult);
                logger.debug("input entry {} ( {} {} ): {} ", new Object[]{conditionContainer.getInputEntry().getId(), conditionContainer.getInputClause().getInputExpression().getText(), conditionContainer.getInputEntry().getText(), conditionResult});
            }
            catch (FlowableDmnExpressionException adee) {
                executionContext.getAuditContainer().addInputEntry(ruleRowIndex, conditionContainer.getInputEntry().getId(), this.getExceptionMessage((Exception)((Object)adee)), conditionResult);
            }
            catch (FlowableException ade) {
                executionContext.getAuditContainer().addInputEntry(ruleRowIndex, conditionContainer.getInputEntry().getId(), this.getExceptionMessage((Exception)((Object)ade)), null);
                throw ade;
            }
            catch (Exception e) {
                executionContext.getAuditContainer().addInputEntry(ruleRowIndex, conditionContainer.getInputEntry().getId(), this.getExceptionMessage(e), null);
                throw new FlowableException(this.getExceptionMessage(e), (Throwable)e);
            }
            if (conditionResult.booleanValue()) continue;
            break;
        }
        if (conditionResult.booleanValue()) {
            this.executeOutputEntryAction(ruleRowIndex, rule.getOutputEntries(), executionContext);
        }
        executionContext.getAuditContainer().markRuleEnd(ruleRowIndex);
        logger.debug("End rule evaluation");
        return conditionResult;
    }

    protected Boolean executeInputExpressionEvaluation(RuleInputClauseContainer ruleContainer, MvelExecutionContext executionContext) {
        return MvelExpressionExecutor.executeInputExpression(ruleContainer.getInputClause(), ruleContainer.getInputEntry(), executionContext);
    }

    protected void executeOutputEntryAction(int ruleRowIndex, List<RuleOutputClauseContainer> ruleOutputContainers, MvelExecutionContext executionContext) {
        logger.debug("Start conclusion processing");
        for (RuleOutputClauseContainer clauseContainer : ruleOutputContainers) {
            if (!StringUtils.isNotEmpty((CharSequence)clauseContainer.getOutputEntry().getText())) continue;
            this.composeOutputEntryResult(ruleRowIndex, clauseContainer, executionContext);
        }
        logger.debug("End conclusion processing");
    }

    protected void composeOutputEntryResult(int ruleRowIndex, RuleOutputClauseContainer ruleClauseContainer, MvelExecutionContext executionContext) {
        String outputVariableId = ruleClauseContainer.getOutputClause().getName();
        String outputVariableType = ruleClauseContainer.getOutputClause().getTypeRef();
        LiteralExpression outputEntryExpression = ruleClauseContainer.getOutputEntry();
        Object executionVariable = null;
        try {
            Object resultVariable = MvelExpressionExecutor.executeOutputExpression(ruleClauseContainer.getOutputClause(), outputEntryExpression, executionContext);
            executionVariable = ExecutionVariableFactory.getExecutionVariable(outputVariableType, resultVariable);
            executionContext.getStackVariables().put(outputVariableId, executionVariable);
            executionContext.getResultVariables().put(outputVariableId, executionVariable);
            executionContext.getAuditContainer().addOutputEntry(ruleRowIndex, outputEntryExpression.getId(), executionVariable);
            if (executionVariable != null) {
                logger.debug("Created conclusion result: {} of type: {} with value {} ", new Object[]{outputVariableId, resultVariable.getClass(), resultVariable.toString()});
            } else {
                logger.warn("Could not create conclusion result");
            }
        }
        catch (FlowableException ade) {
            executionContext.getAuditContainer().addOutputEntry(ruleRowIndex, outputEntryExpression.getId(), this.getExceptionMessage((Exception)((Object)ade)), executionVariable);
            throw ade;
        }
        catch (Exception e) {
            executionContext.getAuditContainer().addOutputEntry(ruleRowIndex, outputEntryExpression.getId(), this.getExceptionMessage(e), executionVariable);
            throw new FlowableException(this.getExceptionMessage(e), (Throwable)e);
        }
    }

    protected String getExceptionMessage(Exception exception) {
        String exceptionMessage = null;
        exceptionMessage = exception.getCause() != null && exception.getCause().getMessage() != null ? exception.getCause().getMessage() : exception.getMessage();
        return exceptionMessage;
    }
}

