/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.rest;

import java.util.ArrayList;
import java.util.List;
import org.flowable.content.api.ContentItem;
import org.flowable.content.rest.ContentRestUrlBuilder;
import org.flowable.content.rest.ContentRestUrls;
import org.flowable.content.rest.service.api.content.ContentItemResponse;

public class ContentRestResponseFactory {
    public ContentItemResponse createContentItemResponse(ContentItem contentItem) {
        return this.createContentItemResponse(contentItem, this.createUrlBuilder());
    }

    public ContentItemResponse createContentItemResponse(ContentItem contentItem, ContentRestUrlBuilder urlBuilder) {
        ContentItemResponse response = new ContentItemResponse(contentItem, urlBuilder.buildUrl(ContentRestUrls.URL_CONTENT_ITEM, contentItem.getId()));
        return response;
    }

    public List<ContentItemResponse> createContentItemResponseList(List<ContentItem> contentItems) {
        ContentRestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<ContentItemResponse> responseList = new ArrayList<ContentItemResponse>(contentItems.size());
        for (ContentItem contentItem : contentItems) {
            responseList.add(this.createContentItemResponse(contentItem, urlBuilder));
        }
        return responseList;
    }

    protected ContentRestUrlBuilder createUrlBuilder() {
        return ContentRestUrlBuilder.fromCurrentRequest();
    }
}

