/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.test;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.flowable.content.api.ContentManagementService;
import org.flowable.content.api.ContentService;
import org.flowable.content.engine.ContentEngine;
import org.flowable.content.engine.ContentEngineConfiguration;
import org.flowable.content.engine.test.ContentTestHelper;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowableContentExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_CONFIGURATION_RESOURCE = "flowable.content.cfg.xml";
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{FlowableContentExtension.class});
    private static final Set<Class<?>> SUPPORTED_PARAMETERS = new HashSet<Class>(Arrays.asList(ContentEngineConfiguration.class, ContentEngine.class, ContentService.class, ContentManagementService.class));
    protected String deploymentId;
    protected ContentEngineConfiguration contentEngineConfiguration;
    protected ContentEngine contentEngine;
    protected ContentService contentService;

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        this.createContentEngine(extensionContext);
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        ContentEngine contentEngine = ContentTestHelper.getContentEngine(this.getConfigurationResource(extensionContext));
        contentEngine.getContentEngineConfiguration().getClock().reset();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return SUPPORTED_PARAMETERS.contains(parameterType);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) {
        ContentEngine contentEngine;
        Class<?> parameterType = parameterContext.getParameter().getType();
        if (parameterType.isInstance(contentEngine = this.getContentEngine(context))) {
            return contentEngine;
        }
        try {
            return ContentEngine.class.getDeclaredMethod("get" + parameterType.getSimpleName(), new Class[0]).invoke((Object)contentEngine, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ParameterResolutionException("Could not find service " + parameterType, (Throwable)ex);
        }
    }

    protected ContentEngine getContentEngine(ExtensionContext context) {
        return ContentTestHelper.getContentEngine(this.getConfigurationResource(context));
    }

    protected ContentEngine createContentEngine(ExtensionContext extensionContext) {
        return ContentTestHelper.getContentEngine(this.getConfigurationResource(extensionContext));
    }

    protected String getConfigurationResource(ExtensionContext context) {
        return DEFAULT_CONFIGURATION_RESOURCE;
    }

    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

