/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.spring.autodeployment;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.flowable.cmmn.api.repository.CmmnDeploymentBuilder;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.common.engine.impl.lock.LockManager;
import org.flowable.common.spring.CommonAutoDeploymentProperties;
import org.flowable.common.spring.CommonAutoDeploymentStrategy;
import org.springframework.core.io.Resource;

public abstract class AbstractCmmnAutoDeploymentStrategy
extends CommonAutoDeploymentStrategy<CmmnEngine> {
    public AbstractCmmnAutoDeploymentStrategy() {
    }

    public AbstractCmmnAutoDeploymentStrategy(CommonAutoDeploymentProperties deploymentProperties) {
        super(deploymentProperties);
    }

    protected LockManager getLockManager(CmmnEngine engine, String deploymentNameHint) {
        return engine.getCmmnEngineConfiguration().getLockManager(this.determineLockName(deploymentNameHint));
    }

    protected void addResource(Resource resource, CmmnDeploymentBuilder deploymentBuilder) {
        String resourceName = this.determineResourceName(resource);
        this.addResource(resource, resourceName, deploymentBuilder);
    }

    protected void addResource(Resource resource, String resourceName, CmmnDeploymentBuilder deploymentBuilder) {
        try (InputStream inputStream = resource.getInputStream();){
            deploymentBuilder.addInputStream(resourceName, inputStream);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to read resource " + resource, ex);
        }
    }
}

