/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.CmmnEngines;
import org.flowable.cmmn.spring.autodeployment.DefaultAutoDeploymentStrategy;
import org.flowable.cmmn.spring.autodeployment.ResourceParentFolderAutoDeploymentStrategy;
import org.flowable.cmmn.spring.autodeployment.SingleResourceAutoDeploymentStrategy;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandInterceptor;
import org.flowable.common.spring.AutoDeploymentStrategy;
import org.flowable.common.spring.SpringEngineConfiguration;
import org.flowable.common.spring.SpringTransactionContextFactory;
import org.flowable.common.spring.SpringTransactionInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringCmmnEngineConfiguration
extends CmmnEngineConfiguration
implements SpringEngineConfiguration {
    protected PlatformTransactionManager transactionManager;
    protected String deploymentName = "SpringAutoDeployment";
    protected Resource[] deploymentResources = new Resource[0];
    protected String deploymentMode = "default";
    protected ApplicationContext applicationContext;
    protected Integer transactionSynchronizationAdapterOrder;
    protected Collection<AutoDeploymentStrategy<CmmnEngine>> deploymentStrategies = new ArrayList<AutoDeploymentStrategy<CmmnEngine>>();
    protected volatile boolean running = false;
    protected List<String> enginesBuild = new ArrayList<String>();
    protected final Object lifeCycleMonitor = new Object();

    public SpringCmmnEngineConfiguration() {
        this.transactionsExternallyManaged = true;
        this.handleCmmnEngineExecutorsAfterEngineCreate = false;
        this.deploymentStrategies.add((AutoDeploymentStrategy<CmmnEngine>)new DefaultAutoDeploymentStrategy());
        this.deploymentStrategies.add((AutoDeploymentStrategy<CmmnEngine>)new SingleResourceAutoDeploymentStrategy());
        this.deploymentStrategies.add((AutoDeploymentStrategy<CmmnEngine>)new ResourceParentFolderAutoDeploymentStrategy());
    }

    public CmmnEngine buildCmmnEngine() {
        CmmnEngine cmmnEngine = super.buildCmmnEngine();
        CmmnEngines.setInitialized((boolean)true);
        this.enginesBuild.add(cmmnEngine.getName());
        return cmmnEngine;
    }

    public void setTransactionSynchronizationAdapterOrder(Integer transactionSynchronizationAdapterOrder) {
        this.transactionSynchronizationAdapterOrder = transactionSynchronizationAdapterOrder;
    }

    public void initDefaultCommandConfig() {
        if (this.defaultCommandConfig == null) {
            this.defaultCommandConfig = new CommandConfig().setContextReusePossible(true);
        }
    }

    public CommandInterceptor createTransactionInterceptor() {
        if (this.transactionManager == null) {
            throw new FlowableException("transactionManager is required property for SpringCmmnEngineConfiguration, use " + CmmnEngineConfiguration.class.getName() + " otherwise");
        }
        return new SpringTransactionInterceptor(this.transactionManager);
    }

    public void initTransactionContextFactory() {
        if (this.transactionContextFactory == null && this.transactionManager != null) {
            this.transactionContextFactory = new SpringTransactionContextFactory(this.transactionManager, this.transactionSynchronizationAdapterOrder);
        }
    }

    protected void autoDeployResources(CmmnEngine cmmnEngine) {
        if (this.deploymentResources != null && this.deploymentResources.length > 0) {
            AutoDeploymentStrategy<CmmnEngine> strategy = this.getAutoDeploymentStrategy(this.deploymentMode);
            strategy.deployResources(this.deploymentName, this.deploymentResources, (Object)cmmnEngine);
        }
    }

    public CmmnEngineConfiguration setDataSource(DataSource dataSource) {
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            return super.setDataSource(dataSource);
        }
        TransactionAwareDataSourceProxy proxiedDataSource = new TransactionAwareDataSourceProxy(dataSource);
        return super.setDataSource((DataSource)proxiedDataSource);
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public Resource[] getDeploymentResources() {
        return this.deploymentResources;
    }

    public void setDeploymentResources(Resource[] deploymentResources) {
        this.deploymentResources = deploymentResources;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getDeploymentMode() {
        return this.deploymentMode;
    }

    public void setDeploymentMode(String deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    protected AutoDeploymentStrategy<CmmnEngine> getAutoDeploymentStrategy(String mode) {
        AutoDeploymentStrategy<CmmnEngine> result = new AutoDeploymentStrategy<CmmnEngine>();
        for (AutoDeploymentStrategy<CmmnEngine> strategy : this.deploymentStrategies) {
            if (!strategy.handlesMode(mode)) continue;
            result = strategy;
            break;
        }
        return result;
    }

    public Collection<AutoDeploymentStrategy<CmmnEngine>> getDeploymentStrategies() {
        return this.deploymentStrategies;
    }

    public void setDeploymentStrategies(Collection<AutoDeploymentStrategy<CmmnEngine>> deploymentStrategies) {
        this.deploymentStrategies = deploymentStrategies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifeCycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                this.enginesBuild.forEach(name -> {
                    CmmnEngine cmmnEngine = CmmnEngines.getCmmnEngine((String)name);
                    cmmnEngine.startExecutors();
                    this.autoDeployResources(cmmnEngine);
                });
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifeCycleMonitor;
        synchronized (object) {
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }
}

