/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.job;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.JobHandler;

public abstract class AbstractCaseInstanceMigrationJobHandler
implements JobHandler {
    public static final String BATCH_RESULT_STATUS_LABEL = "resultStatus";
    public static final String BATCH_RESULT_MESSAGE_LABEL = "resultMessage";
    public static final String BATCH_RESULT_STACKTRACE_LABEL = "resultStacktrace";
    protected static final String CFG_LABEL_BATCH_ID = "batchId";
    protected static final String CFG_LABEL_BATCH_PART_ID = "batchPartId";

    protected static String getBatchIdFromHandlerCfg(String handlerCfg) {
        try {
            JsonNode cfgAsJson = AbstractCaseInstanceMigrationJobHandler.getObjectMapper().readTree(handlerCfg);
            if (cfgAsJson.has(CFG_LABEL_BATCH_ID)) {
                return cfgAsJson.get(CFG_LABEL_BATCH_ID).asText();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected static String getBatchPartIdFromHandlerCfg(String handlerCfg) {
        try {
            JsonNode cfgAsJson = AbstractCaseInstanceMigrationJobHandler.getObjectMapper().readTree(handlerCfg);
            if (cfgAsJson.has(CFG_LABEL_BATCH_PART_ID)) {
                return cfgAsJson.get(CFG_LABEL_BATCH_PART_ID).asText();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getHandlerCfgForBatchId(String batchId) {
        ObjectNode handlerCfg = AbstractCaseInstanceMigrationJobHandler.getObjectMapper().createObjectNode();
        handlerCfg.put(CFG_LABEL_BATCH_ID, batchId);
        return handlerCfg.toString();
    }

    public static String getHandlerCfgForBatchPartId(String batchPartId) {
        ObjectNode handlerCfg = AbstractCaseInstanceMigrationJobHandler.getObjectMapper().createObjectNode();
        handlerCfg.put(CFG_LABEL_BATCH_PART_ID, batchPartId);
        return handlerCfg.toString();
    }

    protected static ObjectMapper getObjectMapper() {
        if (CommandContextUtil.getCommandContext() != null) {
            return CommandContextUtil.getCmmnEngineConfiguration().getObjectMapper();
        }
        return new ObjectMapper();
    }
}

