/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import org.flowable.batch.api.Batch;
import org.flowable.cmmn.api.migration.HistoricCaseInstanceMigrationDocument;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.migration.CaseInstanceMigrationManager;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class HistoricCaseInstanceMigrationBatchCmd
implements Command<Batch> {
    protected CmmnEngineConfiguration cmmnEngineConfiguration;
    protected String caseDefinitionId;
    protected String caseDefinitionKey;
    protected int caseDefinitionVersion;
    protected String caseDefinitionTenantId;
    protected HistoricCaseInstanceMigrationDocument historicCaseInstanceMigrationDocument;

    public HistoricCaseInstanceMigrationBatchCmd(HistoricCaseInstanceMigrationDocument historicCaseInstanceMigrationDocument, String caseDefinitionId, CmmnEngineConfiguration cmmnEngineConfiguration) {
        if (caseDefinitionId == null) {
            throw new FlowableException("Must specify a case definition id to migrate");
        }
        if (historicCaseInstanceMigrationDocument == null) {
            throw new FlowableException("Must specify a historic case instance migration document to migrate");
        }
        this.caseDefinitionId = caseDefinitionId;
        this.historicCaseInstanceMigrationDocument = historicCaseInstanceMigrationDocument;
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public HistoricCaseInstanceMigrationBatchCmd(String caseDefinitionKey, int caseDefinitionVersion, String caseDefinitionTenantId, HistoricCaseInstanceMigrationDocument historicCaseInstanceMigrationDocument, CmmnEngineConfiguration cmmnEngineConfiguration) {
        if (caseDefinitionKey == null) {
            throw new FlowableException("Must specify a case definition id to migrate");
        }
        if (caseDefinitionTenantId == null) {
            throw new FlowableException("Must specify a case definition tenant id to migrate");
        }
        if (historicCaseInstanceMigrationDocument == null) {
            throw new FlowableException("Must specify a historic case instance migration document to migrate");
        }
        this.caseDefinitionKey = caseDefinitionKey;
        this.caseDefinitionVersion = caseDefinitionVersion;
        this.caseDefinitionTenantId = caseDefinitionTenantId;
        this.historicCaseInstanceMigrationDocument = historicCaseInstanceMigrationDocument;
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public Batch execute(CommandContext commandContext) {
        CaseInstanceMigrationManager migrationManager = this.cmmnEngineConfiguration.getCaseInstanceMigrationManager();
        if (this.caseDefinitionId != null) {
            return migrationManager.batchMigrateHistoricCaseInstancesOfCaseDefinition(this.caseDefinitionId, this.historicCaseInstanceMigrationDocument, commandContext);
        }
        if (this.caseDefinitionKey != null && this.caseDefinitionVersion >= 0) {
            return migrationManager.batchMigrateHistoricCaseInstancesOfCaseDefinition(this.caseDefinitionKey, this.caseDefinitionVersion, this.caseDefinitionTenantId, this.historicCaseInstanceMigrationDocument, commandContext);
        }
        throw new FlowableException("Cannot migrate historic case instances, not enough information");
    }
}

