/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.util;

import java.util.HashSet;
import java.util.List;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryManager;
import org.flowable.entitylink.api.EntityLink;
import org.flowable.entitylink.api.EntityLinkService;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;

public class EntityLinkUtil {
    public static void createEntityLinks(String scopeId, String subScopeId, String parentElementId, String referenceScopeId, String referenceScopeType, CmmnEngineConfiguration cmmnEngineConfiguration) {
        String rootScopeType;
        String rootScopeId;
        String hierarchyType;
        EntityLinkService entityLinkService = cmmnEngineConfiguration.getEntityLinkServiceConfiguration().getEntityLinkService();
        List scopeParentEntityLinks = entityLinkService.findEntityLinksByReferenceScopeIdAndType(scopeId, "cmmn", "child");
        HashSet<String> parentIds = new HashSet<String>();
        CmmnHistoryManager historyManager = cmmnEngineConfiguration.getCmmnHistoryManager();
        EntityLink scopeRootEntityLink = null;
        for (EntityLink parentEntityLink : scopeParentEntityLinks) {
            if (parentIds.contains(parentEntityLink.getScopeId())) continue;
            String newHierarchyType = null;
            if ("root".equals(parentEntityLink.getHierarchyType())) {
                scopeRootEntityLink = parentEntityLink;
                newHierarchyType = "root";
            } else if ("parent".equals(parentEntityLink.getHierarchyType()) && "task".equals(referenceScopeType)) {
                newHierarchyType = "grandParent";
            }
            EntityLinkUtil.copyAndCreateEntityLink(subScopeId, parentElementId, referenceScopeId, referenceScopeType, newHierarchyType, parentEntityLink, entityLinkService, historyManager);
            parentIds.add(parentEntityLink.getScopeId());
        }
        if (scopeRootEntityLink != null) {
            hierarchyType = "parent";
            rootScopeId = scopeRootEntityLink.getRootScopeId();
            rootScopeType = scopeRootEntityLink.getRootScopeType();
        } else {
            hierarchyType = "root";
            rootScopeId = scopeId;
            rootScopeType = "cmmn";
        }
        EntityLinkUtil.createEntityLink(scopeId, subScopeId, parentElementId, referenceScopeId, referenceScopeType, hierarchyType, rootScopeId, rootScopeType, entityLinkService, historyManager);
    }

    protected static EntityLinkEntity copyAndCreateEntityLink(String subScopeId, String parentElementId, String referenceScopeId, String referenceScopeType, String hierarchyType, EntityLink parentEntityLink, EntityLinkService entityLinkService, CmmnHistoryManager historyManager) {
        EntityLinkEntity newEntityLink = (EntityLinkEntity)entityLinkService.createEntityLink();
        newEntityLink.setLinkType("child");
        newEntityLink.setScopeId(parentEntityLink.getScopeId());
        newEntityLink.setSubScopeId(subScopeId);
        newEntityLink.setScopeType(parentEntityLink.getScopeType());
        newEntityLink.setScopeDefinitionId(parentEntityLink.getScopeDefinitionId());
        newEntityLink.setParentElementId(parentElementId);
        newEntityLink.setReferenceScopeId(referenceScopeId);
        newEntityLink.setReferenceScopeType(referenceScopeType);
        newEntityLink.setHierarchyType(hierarchyType);
        newEntityLink.setRootScopeId(parentEntityLink.getRootScopeId());
        newEntityLink.setRootScopeType(parentEntityLink.getRootScopeType());
        entityLinkService.insertEntityLink((EntityLink)newEntityLink);
        historyManager.recordEntityLinkCreated(newEntityLink);
        return newEntityLink;
    }

    protected static EntityLinkEntity createEntityLink(String scopeId, String subScopeId, String parentElementId, String referenceScopeId, String referenceScopeType, String hierarchyType, String rootScopeId, String rootScopeType, EntityLinkService entityLinkService, CmmnHistoryManager historyManager) {
        EntityLinkEntity newEntityLink = (EntityLinkEntity)entityLinkService.createEntityLink();
        newEntityLink.setLinkType("child");
        newEntityLink.setScopeId(scopeId);
        newEntityLink.setSubScopeId(subScopeId);
        newEntityLink.setScopeType("cmmn");
        newEntityLink.setParentElementId(parentElementId);
        newEntityLink.setReferenceScopeId(referenceScopeId);
        newEntityLink.setReferenceScopeType(referenceScopeType);
        newEntityLink.setHierarchyType(hierarchyType);
        newEntityLink.setRootScopeId(rootScopeId);
        newEntityLink.setRootScopeType(rootScopeType);
        entityLinkService.insertEntityLink((EntityLink)newEntityLink);
        historyManager.recordEntityLinkCreated(newEntityLink);
        return newEntityLink;
    }
}

