/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import org.flowable.cmmn.api.runtime.InjectedPlanItemInstanceBuilder;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.impl.cmd.CreateInjectedPlanItemInstanceCmd;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;

public class InjectedPlanItemInstanceBuilderImpl
implements InjectedPlanItemInstanceBuilder {
    protected final CommandExecutor commandExecutor;
    protected String stagePlanItemInstanceId;
    protected String caseInstanceId;
    protected String caseDefinitionId;
    protected String elementId;
    protected String name;

    public InjectedPlanItemInstanceBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public InjectedPlanItemInstanceBuilder name(String name) {
        this.name = name;
        return this;
    }

    public InjectedPlanItemInstanceBuilder caseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    public InjectedPlanItemInstanceBuilder elementId(String elementId) {
        this.elementId = elementId;
        return this;
    }

    public PlanItemInstance createInStage(String stagePlanItemInstanceId) {
        this.validateData();
        this.stagePlanItemInstanceId = stagePlanItemInstanceId;
        return (PlanItemInstance)this.commandExecutor.execute((Command)new CreateInjectedPlanItemInstanceCmd(this));
    }

    public PlanItemInstance createInCase(String caseInstanceId) {
        this.validateData();
        this.caseInstanceId = caseInstanceId;
        return (PlanItemInstance)this.commandExecutor.execute((Command)new CreateInjectedPlanItemInstanceCmd(this));
    }

    protected void validateData() {
        if (this.caseDefinitionId == null) {
            throw new FlowableIllegalArgumentException("The case definition id must be provided for the plan item instance");
        }
        if (this.elementId == null) {
            throw new FlowableIllegalArgumentException("The element id must be provided for the plan item instance");
        }
    }

    public boolean injectInStage() {
        return this.stagePlanItemInstanceId != null;
    }

    public boolean injectInCase() {
        return this.caseInstanceId != null;
    }

    public String getStagePlanItemInstanceId() {
        return this.stagePlanItemInstanceId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getName() {
        return this.name;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getElementId() {
        return this.elementId;
    }
}

