/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.delete;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.history.HistoricCaseInstanceQuery;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.delete.BatchDeleteCaseConfig;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class DeleteHistoricCaseInstancesSequentialJobHandler
implements JobHandler {
    public static final String TYPE = "delete-historic-cases-sequential";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        CmmnEngineConfiguration engineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        BatchService batchService = engineConfiguration.getBatchServiceConfiguration().getBatchService();
        BatchDeleteCaseConfig config = BatchDeleteCaseConfig.create(configuration, engineConfiguration);
        BatchPart batchPart = config.getBatchPart();
        Batch batch = config.getBatch();
        if (config.hasError()) {
            this.failBatchPart(engineConfiguration, batchService, batchPart, batch, config.getError());
            return;
        }
        if ("stopped".equals(batch.getStatus())) {
            batchService.completeBatchPart(batchPart.getId(), "stopped", null);
            return;
        }
        int batchSize = config.getBatchSize();
        HistoricCaseInstanceQuery query = config.getQuery();
        List historicCaseInstances = query.listPage(0, batchSize);
        ObjectNode resultNode = engineConfiguration.getObjectMapper().createObjectNode();
        HashSet<String> caseInstanceIdsToDelete = new HashSet<String>();
        for (HistoricCaseInstance historicCaseInstance : historicCaseInstances) {
            caseInstanceIdsToDelete.add(historicCaseInstance.getId());
        }
        if (caseInstanceIdsToDelete.isEmpty()) {
            batchService.completeBatchPart(batchPart.getId(), "completed", resultNode.toString());
            this.completeBatch(batch, "completed", engineConfiguration);
            return;
        }
        String status = "completed";
        CmmnHistoryService historyService = engineConfiguration.getCmmnHistoryService();
        try {
            historyService.bulkDeleteHistoricCaseInstances(caseInstanceIdsToDelete);
            ArrayNode deletedCaseInstanceIdsNode = resultNode.withArray("caseInstanceIdsDeleted");
            caseInstanceIdsToDelete.forEach(arg_0 -> ((ArrayNode)deletedCaseInstanceIdsNode).add(arg_0));
        }
        catch (FlowableException ex) {
            status = "failed";
            ArrayNode caseInstanceIdsFailedToDelete = resultNode.withArray("caseInstanceIdsFailedToDelete");
            caseInstanceIdsToDelete.forEach(arg_0 -> ((ArrayNode)caseInstanceIdsFailedToDelete).add(arg_0));
            resultNode.put("error", ex.getMessage());
            resultNode.put("stacktrace", ExceptionUtils.getStackTrace((Throwable)ex));
        }
        batchService.completeBatchPart(batchPart.getId(), status, resultNode.toString());
        if ("failed".equals(status)) {
            this.completeBatch(batch, "failed", engineConfiguration);
        } else {
            BatchPart nextBatchPart = engineConfiguration.getCmmnManagementService().createBatchPartBuilder(batch).type("deleteCase").searchKey(String.valueOf(Integer.parseInt(batchPart.getSearchKey()) + 1)).status("waiting").create();
            JobService jobService = engineConfiguration.getJobServiceConfiguration().getJobService();
            JobEntity nextJob = jobService.createJob();
            nextJob.setJobHandlerType(TYPE);
            nextJob.setJobHandlerConfiguration(nextBatchPart.getId());
            jobService.createAsyncJob(nextJob, false);
            jobService.scheduleAsyncJob(nextJob);
        }
    }

    protected void failBatchPart(CmmnEngineConfiguration engineConfiguration, BatchService batchService, BatchPart batchPart, Batch batch, String resultJson) {
        batchService.completeBatchPart(batchPart.getId(), "failed", resultJson);
        this.completeBatch(batch, "failed", engineConfiguration);
    }

    protected void completeBatch(Batch batch, String status, CmmnEngineConfiguration engineConfiguration) {
        engineConfiguration.getBatchServiceConfiguration().getBatchService().completeBatch(batch.getId(), status);
    }
}

