/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history.async;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryConfigurationSettings;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricCaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.MilestoneInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.model.Milestone;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.task.api.history.HistoricTaskLogEntryBuilder;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public abstract class AbstractAsyncCmmnHistoryManager
implements CmmnHistoryManager {
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public AbstractAsyncCmmnHistoryManager(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    protected CmmnHistoryConfigurationSettings getHistoryConfigurationSettings() {
        return this.cmmnEngineConfiguration.getCmmnHistoryConfigurationSettings();
    }

    protected void addCommonCaseInstanceFields(CaseInstanceEntity caseInstanceEntity, ObjectNode data) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)caseInstanceEntity.getId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"revision", (Integer)caseInstanceEntity.getRevision());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"name", (String)caseInstanceEntity.getName());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"state", (String)caseInstanceEntity.getState());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"businessKey", (String)caseInstanceEntity.getBusinessKey());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"businessStatus", (String)caseInstanceEntity.getBusinessStatus());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"parentId", (String)caseInstanceEntity.getParentId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseDefinitionId", (String)caseInstanceEntity.getCaseDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"startUserId", (String)caseInstanceEntity.getStartUserId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"startTime", (Date)caseInstanceEntity.getStartTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"callbackId", (String)caseInstanceEntity.getCallbackId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"callbackType", (String)caseInstanceEntity.getCallbackType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"referenceId", (String)caseInstanceEntity.getReferenceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"referenceType", (String)caseInstanceEntity.getReferenceType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"tenantId", (String)caseInstanceEntity.getTenantId());
        if (caseInstanceEntity.getCaseDefinitionId() != null) {
            CaseDefinition caseDefinition = CaseDefinitionUtil.getCaseDefinition(caseInstanceEntity.getCaseDefinitionId());
            this.addCaseDefinitionFields(data, caseDefinition);
        }
    }

    protected void addCommonHistoricCaseInstanceFields(HistoricCaseInstanceEntity historicCaseInstanceEntity, ObjectNode data) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)historicCaseInstanceEntity.getId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"revision", (Integer)historicCaseInstanceEntity.getRevision());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"name", (String)historicCaseInstanceEntity.getName());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"state", (String)historicCaseInstanceEntity.getState());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"businessKey", (String)historicCaseInstanceEntity.getBusinessKey());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"businessStatus", (String)historicCaseInstanceEntity.getBusinessStatus());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"parentId", (String)historicCaseInstanceEntity.getParentId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseDefinitionId", (String)historicCaseInstanceEntity.getCaseDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"startUserId", (String)historicCaseInstanceEntity.getStartUserId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"startTime", (Date)historicCaseInstanceEntity.getStartTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"tenantId", (String)historicCaseInstanceEntity.getTenantId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"callbackId", (String)historicCaseInstanceEntity.getCallbackId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"callbackType", (String)historicCaseInstanceEntity.getCallbackType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"referenceId", (String)historicCaseInstanceEntity.getReferenceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"referenceType", (String)historicCaseInstanceEntity.getReferenceType());
        if (historicCaseInstanceEntity.getCaseDefinitionId() != null) {
            this.addCaseDefinitionFields(data, CaseDefinitionUtil.getCaseDefinition(historicCaseInstanceEntity.getCaseDefinitionId()));
        }
    }

    protected void addCaseDefinitionFields(ObjectNode data, CaseDefinition caseDefinition) {
        if (caseDefinition != null) {
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseDefinitionId", (String)caseDefinition.getId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseDefinitionCategory", (String)caseDefinition.getCategory());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseDefinitionDeploymentId", (String)caseDefinition.getDeploymentId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseDefinitionDescription", (String)caseDefinition.getDescription());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseDefinitionKey", (String)caseDefinition.getKey());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseDefinitionName", (String)caseDefinition.getName());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseDefinitionVersion", (Integer)caseDefinition.getVersion());
        }
    }

    protected void addCommonIdentityLinkFields(IdentityLinkEntity identityLink, ObjectNode data) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)identityLink.getId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"groupId", (String)identityLink.getGroupId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeDefinitionId", (String)identityLink.getScopeDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeId", (String)identityLink.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"subScopeId", (String)identityLink.getSubScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseInstanceId", (String)identityLink.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeType", (String)identityLink.getScopeType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseDefinitionId", (String)identityLink.getScopeDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"taskId", (String)identityLink.getTaskId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processInstanceId", (String)identityLink.getProcessInstanceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"identityLinkType", (String)identityLink.getType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"userId", (String)identityLink.getUserId());
    }

    protected void addCommonEntityLinkFields(EntityLinkEntity entityLink, ObjectNode data) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)entityLink.getId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"entityLinkType", (String)entityLink.getLinkType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"createTime", (Date)entityLink.getCreateTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeId", (String)entityLink.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"subScopeId", (String)entityLink.getSubScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeType", (String)entityLink.getScopeType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeDefinitionId", (String)entityLink.getScopeDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"parentElementId", (String)entityLink.getParentElementId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"refScopeId", (String)entityLink.getReferenceScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"refScopeType", (String)entityLink.getReferenceScopeType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"refScopeDefinitionId", (String)entityLink.getReferenceScopeDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"rootScopeId", (String)entityLink.getRootScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"rootScopeType", (String)entityLink.getRootScopeType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"hierarchyType", (String)entityLink.getHierarchyType());
    }

    protected void addCommonTaskFields(TaskEntity task, ObjectNode data) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)task.getId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"revision", (Integer)task.getRevision());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"name", (String)task.getName());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"parentTaskId", (String)task.getParentTaskId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"description", (String)task.getDescription());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"owner", (String)task.getOwner());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"assignee", (String)task.getAssignee());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"createTime", (Date)task.getCreateTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"taskDefinitionKey", (String)task.getTaskDefinitionKey());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"taskDefinitionId", (String)task.getTaskDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"priority", (Integer)task.getPriority());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"dueDate", (Date)task.getDueDate());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"category", (String)task.getCategory());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"formKey", (String)task.getFormKey());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"tenantId", (String)task.getTenantId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"claimTime", (Date)task.getClaimTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseInstanceId", (String)task.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeId", (String)task.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseInstanceId", (String)task.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"subScopeId", (String)task.getSubScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"planItemInstanceId", (String)task.getSubScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeType", (String)task.getScopeType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeDefinitionId", (String)task.getScopeDefinitionId());
        if (task.getScopeDefinitionId() != null) {
            this.addCaseDefinitionFields(data, CaseDefinitionUtil.getCaseDefinition(task.getScopeDefinitionId()));
        }
    }

    protected void addCommonPlanItemInstanceFields(PlanItemInstanceEntity planItemInstanceEntity, ObjectNode data) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)planItemInstanceEntity.getId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"revision", (Integer)planItemInstanceEntity.getRevision());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"name", (String)planItemInstanceEntity.getName());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"state", (String)planItemInstanceEntity.getState());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseDefinitionId", (String)planItemInstanceEntity.getCaseDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseInstanceId", (String)planItemInstanceEntity.getCaseInstanceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"stageInstanceId", (String)planItemInstanceEntity.getStageInstanceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"isStage", (Boolean)planItemInstanceEntity.isStage());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"elementId", (String)planItemInstanceEntity.getElementId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"planItemDefinitionId", (String)planItemInstanceEntity.getPlanItemDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"planItemDefinitionType", (String)planItemInstanceEntity.getPlanItemDefinitionType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"startUserId", (String)planItemInstanceEntity.getStartUserId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"createTime", (Date)planItemInstanceEntity.getCreateTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"referenceId", (String)planItemInstanceEntity.getReferenceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"referenceType", (String)planItemInstanceEntity.getReferenceType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"entryCriterionId", (String)planItemInstanceEntity.getEntryCriterionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"exitCriterionId", (String)planItemInstanceEntity.getExitCriterionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"extraValue", (String)planItemInstanceEntity.getExtraValue());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"tenantId", (String)planItemInstanceEntity.getTenantId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"lastAvailableTime", (Date)planItemInstanceEntity.getLastAvailableTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"lastUnavailableTime", (Date)planItemInstanceEntity.getLastUnavailableTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"lastEnabledTime", (Date)planItemInstanceEntity.getLastEnabledTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"lastDisabledTime", (Date)planItemInstanceEntity.getLastDisabledTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"lastStartedTime", (Date)planItemInstanceEntity.getLastStartedTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"lastSuspendedTime", (Date)planItemInstanceEntity.getLastSuspendedTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"completedTime", (Date)planItemInstanceEntity.getCompletedTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"occurredTime", (Date)planItemInstanceEntity.getOccurredTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"terminatedTime", (Date)planItemInstanceEntity.getTerminatedTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"exitTime", (Date)planItemInstanceEntity.getExitTime());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"endTime", (Date)planItemInstanceEntity.getEndedTime());
        if (planItemInstanceEntity.getCaseDefinitionId() != null) {
            this.addCaseDefinitionFields(data, CaseDefinitionUtil.getCaseDefinition(planItemInstanceEntity.getCaseDefinitionId()));
        }
    }

    protected void addCommonMilestoneInstanceFields(MilestoneInstanceEntity milestoneInstanceEntity, ObjectNode data) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)milestoneInstanceEntity.getId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"revision", (Integer)milestoneInstanceEntity.getRevision());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"name", (String)milestoneInstanceEntity.getName());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseInstanceId", (String)milestoneInstanceEntity.getCaseInstanceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseDefinitionId", (String)milestoneInstanceEntity.getCaseDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"elementId", (String)milestoneInstanceEntity.getElementId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"createTime", (Date)milestoneInstanceEntity.getTimeStamp());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"tenantId", (String)milestoneInstanceEntity.getTenantId());
        if (milestoneInstanceEntity.getCaseDefinitionId() != null) {
            this.addCaseDefinitionFields(data, CaseDefinitionUtil.getCaseDefinition(milestoneInstanceEntity.getCaseDefinitionId()));
        }
    }

    protected void addCommonVariableFields(VariableInstanceEntity variable, ObjectNode data, Date time) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"id", (String)variable.getId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"taskId", (String)variable.getTaskId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"revision", (Integer)variable.getRevision());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"name", (String)variable.getName());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"executionId", (String)variable.getExecutionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"processInstanceId", (String)variable.getProcessInstanceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseInstanceId", (String)variable.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeId", (String)variable.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"caseInstanceId", (String)variable.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"subScopeId", (String)variable.getSubScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"planItemInstanceId", (String)variable.getSubScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeType", (String)variable.getScopeType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"lastUpdateTime", (Date)time);
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"variableType", (String)variable.getType().getTypeName());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"variableTextValue", (String)variable.getTextValue());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"variableTextValue2", (String)variable.getTextValue2());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"variableDoubleValue", (Double)variable.getDoubleValue());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"variableLongValue", (Long)variable.getLongValue());
        if (variable.getByteArrayRef() != null) {
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"variableBytesValue", (String)AsyncHistoryJsonUtil.convertToBase64((VariableInstanceEntity)variable));
        }
        if (variable.getScopeId() != null && "cmmn".equals(variable.getScopeType())) {
            CaseInstance caseInstance = (CaseInstance)this.cmmnEngineConfiguration.getCaseInstanceEntityManager().findById(variable.getScopeId());
            this.addCaseDefinitionFields(data, CaseDefinitionUtil.getCaseDefinition(caseInstance.getCaseDefinitionId()));
        }
    }

    protected void addCommonHistoricTaskLogEntryFields(HistoricTaskLogEntryBuilder taskLogEntryBuilder, ObjectNode data) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"logEntryData", (String)taskLogEntryBuilder.getData());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeId", (String)taskLogEntryBuilder.getScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeType", (String)taskLogEntryBuilder.getScopeType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"subScopeId", (String)taskLogEntryBuilder.getSubScopeId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"scopeDefinitionId", (String)taskLogEntryBuilder.getScopeDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"taskId", (String)taskLogEntryBuilder.getTaskId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"tenantId", (String)taskLogEntryBuilder.getTenantId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"createTime", (Date)taskLogEntryBuilder.getTimeStamp());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"logEntryType", (String)taskLogEntryBuilder.getType());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)data, (String)"userId", (String)taskLogEntryBuilder.getUserId());
    }

    protected CaseDefinition getCaseDefinition(IdentityLinkEntity identityLink) {
        PlanItemInstanceEntity planItemInstance;
        String caseDefinitionId = null;
        if ("cmmn".equals(identityLink.getScopeType()) && identityLink.getScopeId() != null) {
            CaseInstance caseInstance = (CaseInstance)this.cmmnEngineConfiguration.getCaseInstanceEntityManager().findById(identityLink.getScopeId());
            if (caseInstance != null) {
                caseDefinitionId = caseInstance.getCaseDefinitionId();
            }
        } else if (identityLink.getTaskId() != null) {
            TaskEntity task = this.cmmnEngineConfiguration.getTaskServiceConfiguration().getTaskService().getTask(identityLink.getTaskId());
            if (task != null && "cmmn".equals(task.getScopeType())) {
                caseDefinitionId = task.getScopeDefinitionId();
            }
        } else if ("planItem".equals(identityLink.getScopeType()) && identityLink.getSubScopeId() != null && (planItemInstance = (PlanItemInstanceEntity)this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(identityLink.getSubScopeId())) != null) {
            caseDefinitionId = planItemInstance.getCaseDefinitionId();
        }
        return CaseDefinitionUtil.getCaseDefinition(caseDefinitionId);
    }

    protected Boolean evaluateShowInOverview(PlanItemInstanceEntity planItemInstanceEntity) {
        Boolean showInOverview = null;
        PlanItemDefinition planItemDefinition = planItemInstanceEntity.getPlanItemDefinition();
        String includeInStageOverviewValue = null;
        if (planItemInstanceEntity.isStage()) {
            if (planItemDefinition instanceof Stage) {
                Stage stage = (Stage)planItemDefinition;
                includeInStageOverviewValue = stage.getIncludeInStageOverview();
            }
        } else if (planItemDefinition instanceof Milestone) {
            Milestone milestone = (Milestone)planItemDefinition;
            includeInStageOverviewValue = milestone.getIncludeInStageOverview();
        }
        if (StringUtils.isNotEmpty(includeInStageOverviewValue)) {
            if ("true".equalsIgnoreCase(includeInStageOverviewValue)) {
                showInOverview = true;
            } else if ("false".equalsIgnoreCase(includeInStageOverviewValue)) {
                showInOverview = false;
            } else {
                Expression stageExpression = this.cmmnEngineConfiguration.getExpressionManager().createExpression(includeInStageOverviewValue);
                Object stageValueObject = stageExpression.getValue((VariableContainer)planItemInstanceEntity);
                if (!(stageValueObject instanceof Boolean)) {
                    throw new FlowableException("Include in stage overview expression does not resolve to a boolean value " + includeInStageOverviewValue + ": " + stageValueObject);
                }
                showInOverview = (Boolean)stageValueObject;
            }
        }
        return showInOverview;
    }
}

