/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.api.repository.CmmnDeploymentQuery;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnDeploymentEntity;
import org.flowable.cmmn.engine.impl.repository.CmmnDeploymentBuilderImpl;
import org.flowable.cmmn.engine.impl.repository.CmmnDeploymentQueryImpl;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.repository.EngineDeployment;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class DeployCmd
implements Command<CmmnDeployment> {
    protected CmmnDeploymentBuilderImpl deploymentBuilder;

    public DeployCmd(CmmnDeploymentBuilderImpl deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    public CmmnDeployment execute(CommandContext commandContext) {
        CmmnDeploymentEntity deployment = this.deploymentBuilder.getDeployment();
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        if (this.deploymentBuilder.isDuplicateFilterEnabled()) {
            CmmnDeploymentEntity existingDeployment;
            ArrayList existingDeployments = new ArrayList();
            if (deployment.getTenantId() == null || "".equals(deployment.getTenantId())) {
                List deploymentEntities = ((CmmnDeploymentQuery)new CmmnDeploymentQueryImpl(cmmnEngineConfiguration.getCommandExecutor()).deploymentName(deployment.getName()).orderByDeploymentTime().desc()).listPage(0, 1);
                if (!deploymentEntities.isEmpty()) {
                    existingDeployments.add(deploymentEntities.get(0));
                }
            } else {
                List deploymentList = ((CmmnDeploymentQuery)cmmnEngineConfiguration.getCmmnRepositoryService().createDeploymentQuery().deploymentName(deployment.getName()).deploymentTenantId(deployment.getTenantId()).orderByDeploymentTime().desc()).listPage(0, 1);
                if (!deploymentList.isEmpty()) {
                    existingDeployments.addAll(deploymentList);
                }
            }
            if (!existingDeployments.isEmpty() && !this.deploymentsDiffer(deployment, existingDeployment = (CmmnDeploymentEntity)existingDeployments.get(0))) {
                return existingDeployment;
            }
        }
        deployment.setDeploymentTime(cmmnEngineConfiguration.getClock().getCurrentTime());
        deployment.setNew(true);
        cmmnEngineConfiguration.getCmmnDeploymentEntityManager().insert(deployment);
        if (StringUtils.isEmpty((CharSequence)deployment.getParentDeploymentId())) {
            deployment.setParentDeploymentId(deployment.getId());
        }
        cmmnEngineConfiguration.getDeploymentManager().deploy((EngineDeployment)deployment, null);
        return deployment;
    }

    protected boolean deploymentsDiffer(CmmnDeploymentEntity deployment, CmmnDeploymentEntity saved) {
        if (deployment.getResources() == null || saved.getResources() == null) {
            return true;
        }
        Map resources = deployment.getResources();
        Map savedResources = saved.getResources();
        for (String resourceName : resources.keySet()) {
            byte[] savedBytes;
            EngineResource savedResource = (EngineResource)savedResources.get(resourceName);
            if (savedResource == null) {
                return true;
            }
            EngineResource resource = (EngineResource)resources.get(resourceName);
            byte[] bytes = resource.getBytes();
            if (Arrays.equals(bytes, savedBytes = savedResource.getBytes())) continue;
            return true;
        }
        return false;
    }
}

