/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.flowable.cmmn.api.runtime.PlanItemDefinitionType;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceQuery;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.converter.util.PlanItemDependencyUtil;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CountingPlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityBuilder;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityBuilderImpl;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.data.PlanItemInstanceDataManager;
import org.flowable.cmmn.engine.impl.runtime.PlanItemInstanceQueryImpl;
import org.flowable.cmmn.engine.impl.util.CaseInstanceUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.PlanFragment;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.scope.ScopeTypes;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.AbstractEngineEntityManager;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntityManager;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntityManager;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntityManager;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class PlanItemInstanceEntityManagerImpl
extends AbstractEngineEntityManager<CmmnEngineConfiguration, PlanItemInstanceEntity, PlanItemInstanceDataManager>
implements PlanItemInstanceEntityManager {
    public PlanItemInstanceEntityManagerImpl(CmmnEngineConfiguration cmmnEngineConfiguration, PlanItemInstanceDataManager planItemInstanceDataManager) {
        super((AbstractEngineConfiguration)cmmnEngineConfiguration, (DataManager)planItemInstanceDataManager);
    }

    @Override
    public PlanItemInstanceEntityBuilder createPlanItemInstanceEntityBuilder() {
        return new PlanItemInstanceEntityBuilderImpl(this);
    }

    public PlanItemInstanceEntity createChildPlanItemInstance(PlanItemInstanceEntityBuilderImpl builder) {
        ExpressionManager expressionManager = ((CmmnEngineConfiguration)this.engineConfiguration).getExpressionManager();
        PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)this.create();
        planItemInstanceEntity.setCaseDefinitionId(builder.getCaseDefinitionId());
        planItemInstanceEntity.setDerivedCaseDefinitionId(builder.getDerivedCaseDefinitionId());
        planItemInstanceEntity.setCaseInstanceId(builder.getCaseInstanceId());
        planItemInstanceEntity.setCreateTime(((CmmnEngineConfiguration)this.engineConfiguration).getClock().getCurrentTime());
        planItemInstanceEntity.setElementId(builder.getPlanItem().getId());
        PlanItemDefinition planItemDefinition = builder.getPlanItem().getPlanItemDefinition();
        if (planItemDefinition != null) {
            planItemInstanceEntity.setPlanItemDefinitionId(planItemDefinition.getId());
            String planItemDefinitionType = planItemDefinition.getClass().getSimpleName().toLowerCase();
            planItemInstanceEntity.setPlanItemDefinitionType(planItemDefinitionType);
            planItemInstanceEntity.setStage(PlanItemDefinitionType.STAGE.equals(planItemDefinitionType));
        } else {
            planItemInstanceEntity.setStage(false);
        }
        PlanItemInstance stagePlanItemInstance = builder.getStagePlanItemInstance();
        if (stagePlanItemInstance != null) {
            planItemInstanceEntity.setStageInstanceId(stagePlanItemInstance.getId());
            if (stagePlanItemInstance.getDerivedCaseDefinitionId() != null && builder.getDerivedCaseDefinitionId() == null) {
                planItemInstanceEntity.setDerivedCaseDefinitionId(stagePlanItemInstance.getDerivedCaseDefinitionId());
            }
        }
        planItemInstanceEntity.setTenantId(builder.getTenantId());
        this.insert(planItemInstanceEntity);
        if (builder.hasLocalVariables()) {
            planItemInstanceEntity.setVariablesLocal(builder.getLocalVariables());
        }
        if (builder.getName() != null) {
            planItemInstanceEntity.setName(builder.getName());
        } else if (builder.getPlanItem().getName() != null) {
            String name;
            Expression nameExpression = expressionManager.createExpression(builder.getPlanItem().getName());
            if (builder.isSilentNameExpressionEvaluation()) {
                try {
                    name = nameExpression.getValue((VariableContainer)planItemInstanceEntity).toString();
                }
                catch (Exception e) {
                    name = builder.getPlanItem().getName();
                }
            } else {
                name = nameExpression.getValue((VariableContainer)planItemInstanceEntity).toString();
            }
            planItemInstanceEntity.setName(name);
        }
        if (builder.addToParent) {
            this.addPlanItemInstanceToParent(planItemInstanceEntity);
        }
        return planItemInstanceEntity;
    }

    protected void addPlanItemInstanceToParent(PlanItemInstanceEntity planItemInstanceEntity) {
        if (planItemInstanceEntity.getStageInstanceId() != null) {
            PlanItemInstanceEntity stagePlanItemInstanceEntity = (PlanItemInstanceEntity)((CmmnEngineConfiguration)this.engineConfiguration).getPlanItemInstanceEntityManager().findById(planItemInstanceEntity.getStageInstanceId());
            stagePlanItemInstanceEntity.getChildPlanItemInstances().add(planItemInstanceEntity);
        } else {
            CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)((CmmnEngineConfiguration)this.engineConfiguration).getCaseInstanceEntityManager().findById(planItemInstanceEntity.getCaseInstanceId());
            caseInstanceEntity.getChildPlanItemInstances().add(planItemInstanceEntity);
        }
    }

    @Override
    public void deleteSentryRelatedData(String planItemId) {
        PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)((PlanItemInstanceDataManager)this.dataManager).findById(planItemId);
        this.deleteSentryPartInstances(planItemInstanceEntity);
        this.deleteOrphanEventListeners(planItemInstanceEntity);
    }

    protected void deleteSentryPartInstances(PlanItemInstanceEntity planItemInstanceEntity) {
        SentryPartInstanceEntityManager sentryPartInstanceEntityManager = ((CmmnEngineConfiguration)this.engineConfiguration).getSentryPartInstanceEntityManager();
        if (!(planItemInstanceEntity.getPlanItem() == null || planItemInstanceEntity.getPlanItem().getEntryCriteria().isEmpty() && planItemInstanceEntity.getPlanItem().getExitCriteria().isEmpty() || planItemInstanceEntity.getSatisfiedSentryPartInstances() == null)) {
            for (SentryPartInstanceEntity sentryPartInstanceEntity : planItemInstanceEntity.getSatisfiedSentryPartInstances()) {
                sentryPartInstanceEntityManager.delete(sentryPartInstanceEntity);
            }
            planItemInstanceEntity.setSatisfiedSentryPartInstances(null);
        }
    }

    protected void deleteOrphanEventListeners(PlanItemInstanceEntity planItemInstanceEntity) {
        List<PlanItem> eventListenerDependencies;
        PlanItem planItem = planItemInstanceEntity.getPlanItem();
        if (planItem != null && !(eventListenerDependencies = this.gatherEventListenerDependencies(planItem, planItemInstanceEntity)).isEmpty()) {
            this.terminateOrphanedEventListeners(planItemInstanceEntity, eventListenerDependencies);
        }
    }

    protected List<PlanItem> gatherEventListenerDependencies(PlanItem planItem, PlanItemInstanceEntity planItemInstanceEntity) {
        if (ExpressionUtil.hasRepetitionRule(planItem)) {
            return Collections.emptyList();
        }
        List<PlanItem> eventListenerDependencies = Stream.concat(planItem.getEntryDependencies().stream().filter(p -> p.getPlanItemDefinition() instanceof EventListener), planItem.getExitDependencies().stream().filter(p -> p.getPlanItemDefinition() instanceof EventListener)).collect(Collectors.toList());
        if (planItem.getPlanItemDefinition() instanceof PlanFragment && PlanItemInstanceState.isInTerminalState((PlanItemInstance)planItemInstanceEntity)) {
            List<PlanItem> childPlanItemsWithDependencies = this.getChildPlanItemsWithDependencies((PlanFragment)planItem.getPlanItemDefinition());
            CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)((CmmnEngineConfiguration)this.engineConfiguration).getCaseInstanceEntityManager().findById(planItemInstanceEntity.getCaseInstanceId());
            Map<String, List<PlanItemInstanceEntity>> childPlanItemInstancesMap = CaseInstanceUtil.findChildPlanItemInstancesMap(caseInstanceEntity, childPlanItemsWithDependencies);
            for (PlanItem childPlanItemWithDependencies : childPlanItemsWithDependencies) {
                if (childPlanItemInstancesMap.containsKey(childPlanItemWithDependencies.getId())) continue;
                eventListenerDependencies.addAll(childPlanItemWithDependencies.getEntryDependencies().stream().filter(p -> p.getPlanItemDefinition() instanceof EventListener).collect(Collectors.toList()));
                eventListenerDependencies.addAll(childPlanItemWithDependencies.getExitDependencies().stream().filter(p -> p.getPlanItemDefinition() instanceof EventListener).collect(Collectors.toList()));
            }
        }
        return eventListenerDependencies;
    }

    protected void terminateOrphanedEventListeners(PlanItemInstanceEntity planItemInstanceEntity, List<PlanItem> eventListenerDependencies) {
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)((CmmnEngineConfiguration)this.engineConfiguration).getCaseInstanceEntityManager().findById(planItemInstanceEntity.getCaseInstanceId());
        for (PlanItem eventListenerPlanItem : eventListenerDependencies) {
            List<PlanItemInstanceEntity> eventListenerPlanItemInstance = CaseInstanceUtil.findNonTerminalChildPlanItemInstances(caseInstanceEntity, eventListenerPlanItem);
            if (eventListenerPlanItemInstance.isEmpty()) continue;
            List dependentPlanItems = eventListenerPlanItem.getAllDependentPlanItems();
            Map<String, List<PlanItemInstanceEntity>> dependentPlanItemInstancesMap = CaseInstanceUtil.findChildPlanItemInstancesMap(caseInstanceEntity, dependentPlanItems);
            boolean isOrphan = true;
            Iterator planItemIterator = dependentPlanItems.iterator();
            while (isOrphan && planItemIterator.hasNext()) {
                PlanItem dependentPlanItem = (PlanItem)planItemIterator.next();
                List<PlanItemInstanceEntity> dependentPlanItemInstances = dependentPlanItemInstancesMap.get(dependentPlanItem.getId());
                if (dependentPlanItemInstances != null && !dependentPlanItemInstances.isEmpty()) {
                    for (PlanItemInstanceEntity dependentPlanItemInstance : dependentPlanItemInstances) {
                        if (PlanItemDependencyUtil.isEntryDependency((PlanItem)dependentPlanItemInstance.getPlanItem(), (PlanItem)eventListenerPlanItem) && ("available".equals(dependentPlanItemInstance.getState()) || "wait_repetition".equals(dependentPlanItemInstance.getState()))) {
                            isOrphan = false;
                        }
                        if (!PlanItemDependencyUtil.isExitDependency((PlanItem)dependentPlanItemInstance.getPlanItem(), (PlanItem)eventListenerPlanItem) || PlanItemInstanceState.TERMINAL_STATES.contains(dependentPlanItemInstance.getState())) continue;
                        isOrphan = false;
                    }
                    continue;
                }
                Stage parentStage = dependentPlanItem.getParentStage();
                while (isOrphan && parentStage != null && !parentStage.isPlanModel()) {
                    List<PlanItemInstanceEntity> nonTerminalStagePlanItemInstances = CaseInstanceUtil.findNonTerminalChildPlanItemInstances(caseInstanceEntity, parentStage.getPlanItem());
                    if (!nonTerminalStagePlanItemInstances.isEmpty()) {
                        isOrphan = false;
                        continue;
                    }
                    parentStage = parentStage.getParentStage();
                }
            }
            if (!isOrphan) continue;
            for (PlanItemInstanceEntity eventListenerPlanItemInstanceEntity : eventListenerPlanItemInstance) {
                CommandContextUtil.getAgenda().planTerminatePlanItemInstanceOperation(eventListenerPlanItemInstanceEntity, null, null);
            }
        }
    }

    protected List<PlanItem> getChildPlanItemsWithDependencies(PlanFragment planFragment) {
        ArrayList<PlanItem> childPlanItemsWithDependencies = new ArrayList<PlanItem>();
        this.internalGetChildPlanItemsWithDependencies(planFragment, childPlanItemsWithDependencies);
        return childPlanItemsWithDependencies;
    }

    protected void internalGetChildPlanItemsWithDependencies(PlanFragment planFragment, List<PlanItem> childPlanItemsWithDependencies) {
        for (PlanItem planItem : planFragment.getPlanItems()) {
            if (planItem.getEntryDependencies().isEmpty() && planItem.getExitDependencies().isEmpty()) continue;
            childPlanItemsWithDependencies.add(planItem);
            if (!(planItem.getPlanItemDefinition() instanceof PlanFragment)) continue;
            this.internalGetChildPlanItemsWithDependencies((PlanFragment)planItem.getPlanItemDefinition(), childPlanItemsWithDependencies);
        }
    }

    @Override
    public void deleteByCaseDefinitionId(String caseDefinitionId) {
        ((PlanItemInstanceDataManager)this.dataManager).deleteByCaseDefinitionId(caseDefinitionId);
    }

    @Override
    public void deleteByStageInstanceId(String stageInstanceId) {
        ((PlanItemInstanceDataManager)this.dataManager).deleteByStageInstanceId(stageInstanceId);
    }

    @Override
    public void deleteByCaseInstanceId(String caseInstanceId) {
        ((PlanItemInstanceDataManager)this.dataManager).deleteByCaseInstanceId(caseInstanceId);
    }

    @Override
    public PlanItemInstanceQuery createPlanItemInstanceQuery() {
        return new PlanItemInstanceQueryImpl(((CmmnEngineConfiguration)this.engineConfiguration).getCommandExecutor(), (CmmnEngineConfiguration)this.engineConfiguration);
    }

    @Override
    public long countByCriteria(PlanItemInstanceQuery planItemInstanceQuery) {
        return ((PlanItemInstanceDataManager)this.dataManager).countByCriteria((PlanItemInstanceQueryImpl)planItemInstanceQuery);
    }

    @Override
    public List<PlanItemInstance> findByCriteria(PlanItemInstanceQuery planItemInstanceQuery) {
        return ((PlanItemInstanceDataManager)this.dataManager).findByCriteria((PlanItemInstanceQueryImpl)planItemInstanceQuery);
    }

    @Override
    public List<PlanItemInstanceEntity> findByCaseInstanceId(String caseInstanceId) {
        return ((PlanItemInstanceDataManager)this.dataManager).findByCaseInstanceId(caseInstanceId);
    }

    @Override
    public List<PlanItemInstanceEntity> findByStagePlanItemInstanceId(String stagePlanItemInstanceId) {
        return ((PlanItemInstanceDataManager)this.dataManager).findByStagePlanItemInstanceId(stagePlanItemInstanceId);
    }

    @Override
    public List<PlanItemInstanceEntity> findByCaseInstanceIdAndPlanItemId(String caseInstanceId, String planitemId) {
        return ((PlanItemInstanceDataManager)this.dataManager).findByCaseInstanceIdAndPlanItemId(caseInstanceId, planitemId);
    }

    public void delete(PlanItemInstanceEntity planItemInstanceEntity, boolean fireEvent) {
        CountingPlanItemInstanceEntity countingPlanItemInstanceEntity = (CountingPlanItemInstanceEntity)((Object)planItemInstanceEntity);
        if (countingPlanItemInstanceEntity.getVariableCount() > 0) {
            VariableService variableService = ((CmmnEngineConfiguration)this.engineConfiguration).getVariableServiceConfiguration().getVariableService();
            List variableInstanceEntities = variableService.createInternalVariableInstanceQuery().subScopeId(planItemInstanceEntity.getId()).scopeTypes(ScopeTypes.CMMN_DEPENDENT).list();
            for (VariableInstanceEntity variableInstanceEntity : variableInstanceEntities) {
                variableService.deleteVariableInstance(variableInstanceEntity);
            }
        }
        if (planItemInstanceEntity.isStage() && planItemInstanceEntity.getChildPlanItemInstances() != null && !planItemInstanceEntity.getChildPlanItemInstances().isEmpty()) {
            for (PlanItemInstanceEntity childPlanItem : planItemInstanceEntity.getChildPlanItemInstances()) {
                this.delete(childPlanItem, fireEvent);
            }
        }
        if (planItemInstanceEntity.getPlanItemDefinitionType().equals(PlanItemDefinitionType.TIMER_EVENT_LISTENER)) {
            TimerJobEntityManager timerJobEntityManager = ((CmmnEngineConfiguration)this.engineConfiguration).getJobServiceConfiguration().getTimerJobEntityManager();
            List timerJobsEntities = timerJobEntityManager.findJobsByScopeIdAndSubScopeId(planItemInstanceEntity.getCaseInstanceId(), planItemInstanceEntity.getId());
            for (TimerJobEntity timerJobEntity : timerJobsEntities) {
                timerJobEntityManager.delete((Entity)timerJobEntity);
            }
        }
        if (planItemInstanceEntity.getPlanItemDefinitionType().equals(PlanItemDefinitionType.CASE_PAGE_TASK)) {
            IdentityLinkEntityManager identityLinkEntityManager = ((CmmnEngineConfiguration)this.engineConfiguration).getIdentityLinkServiceConfiguration().getIdentityLinkEntityManager();
            List identityLinkEntities = identityLinkEntityManager.findIdentityLinksBySubScopeIdAndType(planItemInstanceEntity.getId(), "planItem");
            for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
                identityLinkEntityManager.delete((Entity)identityLinkEntity);
            }
        }
        if (planItemInstanceEntity.getPlanItemDefinitionType().equals(PlanItemDefinitionType.EXTERNAL_WORKER_TASK)) {
            ExternalWorkerJobEntityManager externalWorkerJobEntityManager = ((CmmnEngineConfiguration)this.engineConfiguration).getJobServiceConfiguration().getExternalWorkerJobEntityManager();
            List externalWorkerJobEntities = externalWorkerJobEntityManager.findJobsByScopeIdAndSubScopeId(planItemInstanceEntity.getCaseInstanceId(), planItemInstanceEntity.getId());
            for (ExternalWorkerJobEntity externalWorkerJobEntity : externalWorkerJobEntities) {
                externalWorkerJobEntityManager.delete((Entity)externalWorkerJobEntity);
            }
        }
        ((PlanItemInstanceDataManager)this.getDataManager()).delete(planItemInstanceEntity);
    }

    @Override
    public void updatePlanItemInstancesCaseDefinitionId(String caseInstanceId, String caseDefinitionId) {
        CommandContext commandContext = Context.getCommandContext();
        PlanItemInstanceQuery planItemQuery = new PlanItemInstanceQueryImpl(commandContext, (CmmnEngineConfiguration)this.engineConfiguration).caseInstanceId(caseInstanceId).includeEnded();
        List<PlanItemInstance> planItemInstances = this.findByCriteria(planItemQuery);
        if (planItemInstances != null) {
            for (PlanItemInstance planItemInstance : planItemInstances) {
                PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)planItemInstance;
                planItemInstanceEntity.setCaseDefinitionId(caseDefinitionId);
                this.update(planItemInstanceEntity);
            }
        }
    }

    protected CaseInstanceEntityManager getCaseInstanceEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getCaseInstanceEntityManager();
    }
}

