/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity;

import java.util.List;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.api.repository.CmmnDeploymentQuery;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnDeploymentEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnDeploymentEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnResourceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnResourceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.data.CmmnDeploymentDataManager;
import org.flowable.cmmn.engine.impl.repository.CmmnDeploymentQueryImpl;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.persistence.entity.AbstractEngineEntityManager;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;

public class CmmnDeploymentEntityManagerImpl
extends AbstractEngineEntityManager<CmmnEngineConfiguration, CmmnDeploymentEntity, CmmnDeploymentDataManager>
implements CmmnDeploymentEntityManager {
    public CmmnDeploymentEntityManagerImpl(CmmnEngineConfiguration cmmnEngineConfiguration, CmmnDeploymentDataManager deploymentDataManager) {
        super((AbstractEngineConfiguration)cmmnEngineConfiguration, (DataManager)deploymentDataManager);
    }

    public void insert(CmmnDeploymentEntity deployment) {
        super.insert((Entity)deployment, true);
        for (EngineResource resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getCmmnResourceEntityManager().insert((CmmnResourceEntity)resource);
        }
    }

    @Override
    public void deleteDeploymentAndRelatedData(String deploymentId, boolean cascade) {
        CaseDefinitionEntityManager caseDefinitionEntityManager = this.getCaseDefinitionEntityManager();
        List caseDefinitions = caseDefinitionEntityManager.createCaseDefinitionQuery().deploymentId(deploymentId).list();
        for (CaseDefinition caseDefinition : caseDefinitions) {
            ((CmmnEngineConfiguration)this.engineConfiguration).getIdentityLinkServiceConfiguration().getIdentityLinkService().deleteIdentityLinksByScopeDefinitionIdAndType(caseDefinition.getId(), "cmmn");
            ((CmmnEngineConfiguration)this.engineConfiguration).getEventSubscriptionServiceConfiguration().getEventSubscriptionService().deleteEventSubscriptionsForScopeDefinitionIdAndType(caseDefinition.getId(), "cmmn");
            if (cascade) {
                caseDefinitionEntityManager.deleteCaseDefinitionAndRelatedData(caseDefinition.getId(), true);
                continue;
            }
            caseDefinitionEntityManager.delete(caseDefinition.getId());
        }
        this.getCmmnResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete(this.findById(deploymentId));
    }

    @Override
    public CmmnDeploymentEntity findLatestDeploymentByName(String deploymentName) {
        return ((CmmnDeploymentDataManager)this.dataManager).findLatestDeploymentByName(deploymentName);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return ((CmmnDeploymentDataManager)this.dataManager).getDeploymentResourceNames(deploymentId);
    }

    @Override
    public CmmnDeploymentQuery createDeploymentQuery() {
        return new CmmnDeploymentQueryImpl(((CmmnEngineConfiguration)this.engineConfiguration).getCommandExecutor());
    }

    @Override
    public List<CmmnDeployment> findDeploymentsByQueryCriteria(CmmnDeploymentQuery deploymentQuery) {
        return ((CmmnDeploymentDataManager)this.dataManager).findDeploymentsByQueryCriteria((CmmnDeploymentQueryImpl)deploymentQuery);
    }

    @Override
    public long findDeploymentCountByQueryCriteria(CmmnDeploymentQuery deploymentQuery) {
        return ((CmmnDeploymentDataManager)this.dataManager).findDeploymentCountByQueryCriteria((CmmnDeploymentQueryImpl)deploymentQuery);
    }

    protected CmmnResourceEntityManager getCmmnResourceEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getCmmnResourceEntityManager();
    }

    protected CaseDefinitionEntityManager getCaseDefinitionEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getCaseDefinitionEntityManager();
    }
}

