/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.test;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.CmmnTaskService;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.test.impl.CmmnTestHelper;
import org.flowable.common.engine.api.FlowableException;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class FlowableCmmnRule
implements TestRule {
    protected String configurationResource = "flowable.cmmn.cfg.xml";
    protected String deploymentId;
    protected CmmnEngineConfiguration cmmnEngineConfiguration;
    protected CmmnEngine cmmnEngine;
    protected CmmnRepositoryService cmmnRepositoryService;
    protected CmmnRuntimeService cmmnRuntimeService;
    protected CmmnTaskService cmmnTaskService;
    protected CmmnHistoryService cmmnHistoryService;
    protected CmmnManagementService cmmnManagementService;

    public FlowableCmmnRule() {
    }

    public FlowableCmmnRule(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public FlowableCmmnRule(CmmnEngine cmmnEngine) {
        this.setCmmnEngine(cmmnEngine);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                FlowableCmmnRule.this.startingQuietly(description, errors);
                try {
                    base.evaluate();
                    FlowableCmmnRule.this.succeededQuietly(description, errors);
                }
                catch (AssumptionViolatedException e) {
                    errors.add(e);
                    FlowableCmmnRule.this.skippedQuietly(e, description, errors);
                }
                catch (Throwable t) {
                    errors.add(t);
                    FlowableCmmnRule.this.failedQuietly(t, description, errors);
                }
                finally {
                    FlowableCmmnRule.this.finishedQuietly(description, errors);
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    private void succeededQuietly(Description description, List<Throwable> errors) {
        try {
            this.succeeded(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void failedQuietly(Throwable t, Description description, List<Throwable> errors) {
        try {
            this.failed(t, description);
        }
        catch (Throwable t1) {
            errors.add(t1);
        }
    }

    private void skippedQuietly(AssumptionViolatedException e, Description description, List<Throwable> errors) {
        try {
            this.skipped(e, description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void startingQuietly(Description description, List<Throwable> errors) {
        try {
            this.starting(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void finishedQuietly(Description description, List<Throwable> errors) {
        try {
            this.finished(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    protected void succeeded(Description description) {
    }

    protected void failed(Throwable e, Description description) {
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
    }

    protected void starting(Description description) {
        if (this.cmmnEngine == null) {
            this.initializeCmmnEngine();
        }
        if (this.cmmnEngineConfiguration == null) {
            this.initializeServices();
        }
        this.configureProcessEngine();
        try {
            this.deploymentId = CmmnTestHelper.annotationDeploymentSetUp(this.cmmnEngine, Class.forName(description.getClassName()), description.getMethodName());
        }
        catch (ClassNotFoundException e) {
            throw new FlowableException("Programmatic error: could not instantiate " + description.getClassName(), (Throwable)e);
        }
    }

    protected void initializeCmmnEngine() {
        this.cmmnEngine = CmmnTestHelper.getCmmnEngine(this.configurationResource);
    }

    protected void initializeServices() {
        this.cmmnEngineConfiguration = this.cmmnEngine.getCmmnEngineConfiguration();
        this.cmmnRepositoryService = this.cmmnEngine.getCmmnRepositoryService();
        this.cmmnRuntimeService = this.cmmnEngine.getCmmnRuntimeService();
        this.cmmnTaskService = this.cmmnEngine.getCmmnTaskService();
        this.cmmnHistoryService = this.cmmnEngine.getCmmnHistoryService();
        this.cmmnManagementService = this.cmmnEngine.getCmmnManagementService();
    }

    protected void configureProcessEngine() {
    }

    protected void finished(Description description) {
        try {
            CmmnTestHelper.annotationDeploymentTearDown(this.cmmnEngine, this.deploymentId, Class.forName(description.getClassName()), description.getMethodName());
        }
        catch (ClassNotFoundException e) {
            throw new FlowableException("Programmatic error: could not instantiate " + description.getClassName(), (Throwable)e);
        }
        this.cmmnEngineConfiguration.getClock().reset();
    }

    public void setCurrentTime(Date currentTime) {
        this.cmmnEngineConfiguration.getClock().setCurrentTime(currentTime);
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public CmmnEngine getCmmnEngine() {
        return this.cmmnEngine;
    }

    public void setCmmnEngine(CmmnEngine cmmnEngine) {
        this.cmmnEngine = cmmnEngine;
        this.initializeServices();
    }

    public CmmnEngineConfiguration getCmmnEngineConfiguration() {
        return this.cmmnEngineConfiguration;
    }

    public CmmnRepositoryService getCmmnRepositoryService() {
        return this.cmmnRepositoryService;
    }

    public CmmnRuntimeService getCmmnRuntimeService() {
        return this.cmmnRuntimeService;
    }

    public CmmnTaskService getCmmnTaskService() {
        return this.cmmnTaskService;
    }

    public CmmnHistoryService getCmmnHistoryService() {
        return this.cmmnHistoryService;
    }

    public CmmnManagementService getCmmnManagementService() {
        return this.cmmnManagementService;
    }
}

