/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.migration.ActivatePlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.MoveToAvailablePlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.TerminatePlanItemDefinitionMapping;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.agenda.CmmnEngineAgenda;
import org.flowable.cmmn.engine.impl.behavior.impl.ChildTaskActivityBehavior;
import org.flowable.cmmn.engine.impl.deployer.CmmnDeploymentManager;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceChangeState;
import org.flowable.cmmn.engine.impl.runtime.MovePlanItemInstanceEntityContainer;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.cmmn.engine.interceptor.MigrationContext;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.CaseTask;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.ProcessTask;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCmmnDynamicStateManager {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public AbstractCmmnDynamicStateManager(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    protected PlanItem resolvePlanItemFromCmmnModelWithDefinitionId(String planItemDefinitionId, String caseDefinitionId) {
        CmmnModel cmmnModel = CaseDefinitionUtil.getCmmnModel(caseDefinitionId);
        PlanItem planItem = cmmnModel.findPlanItemByPlanItemDefinitionId(planItemDefinitionId);
        if (planItem == null) {
            throw new FlowableException("Cannot find plan item with definition id '" + planItemDefinitionId + "' in case definition with id '" + caseDefinitionId + "'");
        }
        return planItem;
    }

    protected PlanItem resolvePlanItemFromCmmnModel(CmmnModel cmmnModel, String planItemId, String caseDefinitionId) {
        PlanItem planItem = cmmnModel.findPlanItem(planItemId);
        if (planItem == null) {
            throw new FlowableException("Cannot find plan item '" + planItemId + "' in case definition with id '" + caseDefinitionId + "'");
        }
        return planItem;
    }

    protected void doMovePlanItemState(CaseInstanceChangeState caseInstanceChangeState, CommandContext commandContext) {
        Map<String, List<PlanItemInstanceEntity>> currentPlanItemInstances = this.resolvePlanItemInstances(caseInstanceChangeState.getCaseInstanceId(), caseInstanceChangeState.getCaseDefinitionToMigrateTo(), commandContext);
        caseInstanceChangeState.setCurrentPlanItemInstances(currentPlanItemInstances);
        CaseInstanceEntityManager caseInstanceEntityManager = this.cmmnEngineConfiguration.getCaseInstanceEntityManager();
        CaseInstanceEntity caseInstance = (CaseInstanceEntity)caseInstanceEntityManager.findById(caseInstanceChangeState.getCaseInstanceId());
        caseInstance.setVariables(caseInstanceChangeState.getCaseVariables());
        this.executeTerminatePlanItemInstances(caseInstanceChangeState, caseInstance, commandContext);
        this.executeActivatePlanItemInstances(caseInstanceChangeState, caseInstance, true, commandContext);
        this.executeActivatePlanItemInstances(caseInstanceChangeState, caseInstance, false, commandContext);
        this.executeChangePlanItemInstancesToAvailableState(caseInstanceChangeState, caseInstance, true, commandContext);
        this.executeChangePlanItemInstancesToAvailableState(caseInstanceChangeState, caseInstance, false, commandContext);
        CmmnEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
        agenda.planEvaluateCriteriaOperation(caseInstance.getId());
    }

    protected void executeActivatePlanItemInstances(CaseInstanceChangeState caseInstanceChangeState, CaseInstanceEntity caseInstance, boolean onlyStages, CommandContext commandContext) {
        if (caseInstanceChangeState.getActivatePlanItemDefinitions() == null || caseInstanceChangeState.getActivatePlanItemDefinitions().isEmpty()) {
            return;
        }
        for (ActivatePlanItemDefinitionMapping planItemDefinitionMapping : caseInstanceChangeState.getActivatePlanItemDefinitions()) {
            PlanItem planItem = this.resolvePlanItemFromCmmnModelWithDefinitionId(planItemDefinitionMapping.getPlanItemDefinitionId(), caseInstance.getCaseDefinitionId());
            if (!(planItem.getPlanItemDefinition() instanceof Stage) && onlyStages || planItem.getPlanItemDefinition() instanceof Stage && !onlyStages) continue;
            PlanItemInstanceEntity newPlanItemInstance = this.createStagesAndPlanItemInstances(planItem, caseInstance, caseInstanceChangeState, commandContext);
            CmmnEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
            if (planItemDefinitionMapping.getNewAssignee() != null && planItem.getPlanItemDefinition() instanceof HumanTask) {
                MigrationContext migrationContext = new MigrationContext();
                migrationContext.setAssignee(planItemDefinitionMapping.getNewAssignee());
                agenda.planStartPlanItemInstanceOperation(newPlanItemInstance, null, migrationContext);
            } else if (caseInstanceChangeState.getChildInstanceTaskVariables().containsKey(planItemDefinitionMapping.getPlanItemDefinitionId()) && (planItem.getPlanItemDefinition() instanceof ProcessTask || planItem.getPlanItemDefinition() instanceof CaseTask)) {
                agenda.planStartPlanItemInstanceOperation(newPlanItemInstance, null, new ChildTaskActivityBehavior.VariableInfo(caseInstanceChangeState.getChildInstanceTaskVariables().get(planItemDefinitionMapping.getPlanItemDefinitionId())));
            } else {
                agenda.planStartPlanItemInstanceOperation(newPlanItemInstance, null);
            }
            if (newPlanItemInstance.getPlanItem().getEntryCriteria().isEmpty() || !this.hasRepetitionRule(newPlanItemInstance) || !this.evaluateRepetitionRule(newPlanItemInstance, commandContext)) continue;
            this.createPlanItemInstanceDuplicateForRepetition(newPlanItemInstance, commandContext);
        }
    }

    protected void executeChangePlanItemInstancesToAvailableState(CaseInstanceChangeState caseInstanceChangeState, CaseInstanceEntity caseInstance, boolean onlyStages, CommandContext commandContext) {
        if (caseInstanceChangeState.getChangePlanItemDefinitionsToAvailable() == null || caseInstanceChangeState.getChangePlanItemDefinitionsToAvailable().isEmpty()) {
            return;
        }
        PlanItemInstanceEntityManager planItemInstanceEntityManager = this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager();
        for (MoveToAvailablePlanItemDefinitionMapping planItemDefinitionMapping : caseInstanceChangeState.getChangePlanItemDefinitionsToAvailable()) {
            PlanItem planItem = this.resolvePlanItemFromCmmnModelWithDefinitionId(planItemDefinitionMapping.getPlanItemDefinitionId(), caseInstance.getCaseDefinitionId());
            if (!(planItem.getPlanItemDefinition() instanceof Stage) && onlyStages || planItem.getPlanItemDefinition() instanceof Stage && !onlyStages) continue;
            List planItemInstances = planItemInstanceEntityManager.createPlanItemInstanceQuery().caseInstanceId(caseInstance.getId()).planItemDefinitionId(planItemDefinitionMapping.getPlanItemDefinitionId()).list();
            ArrayList<PlanItemInstance> activePlanItemInstances = new ArrayList<PlanItemInstance>();
            if (planItemInstances != null && !planItemInstances.isEmpty()) {
                for (PlanItemInstance planItemInstance : planItemInstances) {
                    if (PlanItemInstanceState.TERMINAL_STATES.contains(planItemInstance.getState())) continue;
                    activePlanItemInstances.add(planItemInstance);
                }
            }
            if (activePlanItemInstances.isEmpty()) {
                PlanItemInstanceEntity parentPlanItemInstance = null;
                if (planItem.getParentStage() != null && caseInstanceChangeState.getCreatedStageInstances().containsKey(planItem.getParentStage().getId())) {
                    parentPlanItemInstance = caseInstanceChangeState.getCreatedStageInstances().get(planItem.getParentStage().getId());
                } else if (planItem.getParentStage() != null) {
                    List<PlanItemInstanceEntity> caseInstancePlanItemInstances = planItemInstanceEntityManager.findByCaseInstanceId(caseInstance.getId());
                    for (PlanItemInstanceEntity caseInstancePlanItemInstance : caseInstancePlanItemInstances) {
                        if (!caseInstancePlanItemInstance.getPlanItemDefinitionId().equals(planItem.getParentStage().getId())) continue;
                        parentPlanItemInstance = caseInstancePlanItemInstance;
                        break;
                    }
                }
                PlanItemInstanceEntity availablePlanItemInstance = planItemInstanceEntityManager.createPlanItemInstanceEntityBuilder().planItem(planItem).caseDefinitionId(caseInstance.getCaseDefinitionId()).caseInstanceId(caseInstance.getId()).stagePlanItemInstance((PlanItemInstance)parentPlanItemInstance).tenantId(caseInstance.getTenantId()).addToParent(true).create();
                if (planItem.getPlanItemDefinition() instanceof Stage) {
                    caseInstanceChangeState.addCreatedStageInstance(planItemDefinitionMapping.getPlanItemDefinitionId(), availablePlanItemInstance);
                }
                CmmnHistoryManager cmmnHistoryManager = this.cmmnEngineConfiguration.getCmmnHistoryManager();
                cmmnHistoryManager.recordPlanItemInstanceCreated(availablePlanItemInstance);
                CmmnEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
                agenda.planChangePlanItemInstanceToAvailableOperation(availablePlanItemInstance);
                continue;
            }
            PlanItemInstance existingPlanItemInstance = null;
            for (PlanItemInstance planItemInstance : planItemInstances) {
                if (!"active".equals(planItemInstance.getState()) && !"enabled".equals(planItemInstance.getState())) continue;
                if (existingPlanItemInstance != null) {
                    throw new FlowableException("multiple active or enabled plan item instances found for plan item definition " + planItemDefinitionMapping.getPlanItemDefinitionId());
                }
                existingPlanItemInstance = planItemInstance;
            }
            if (existingPlanItemInstance == null) {
                throw new FlowableException("No active or enabled plan item instances found for plan item definition " + planItemDefinitionMapping.getPlanItemDefinitionId());
            }
            PlanItemInstanceEntity existingPlanItemInstanceEntity = (PlanItemInstanceEntity)existingPlanItemInstance;
            if (existingPlanItemInstanceEntity.getPlanItem().getPlanItemDefinition() instanceof HumanTask) {
                TaskService taskService = this.cmmnEngineConfiguration.getTaskServiceConfiguration().getTaskService();
                List taskEntities = taskService.findTasksBySubScopeIdScopeType(existingPlanItemInstanceEntity.getId(), "cmmn");
                if (taskEntities == null || taskEntities.isEmpty()) {
                    throw new FlowableException("No task entity found for plan item instance " + existingPlanItemInstanceEntity.getId());
                }
                for (TaskEntity taskEntity : taskEntities) {
                    if (taskEntity.isDeleted()) continue;
                    TaskHelper.deleteTask(taskEntity, "Change plan item state", false, false, this.cmmnEngineConfiguration);
                }
            }
            CmmnEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
            agenda.planChangePlanItemInstanceToAvailableOperation(existingPlanItemInstanceEntity);
        }
    }

    protected void executeTerminatePlanItemInstances(CaseInstanceChangeState caseInstanceChangeState, CaseInstanceEntity caseInstance, CommandContext commandContext) {
        if (caseInstanceChangeState.getTerminatePlanItemDefinitions() == null || caseInstanceChangeState.getTerminatePlanItemDefinitions().isEmpty()) {
            return;
        }
        Map<String, List<PlanItemInstanceEntity>> currentPlanItemInstanceMap = caseInstanceChangeState.getCurrentPlanItemInstances();
        for (TerminatePlanItemDefinitionMapping planItemDefinitionMapping : caseInstanceChangeState.getTerminatePlanItemDefinitions()) {
            if (!currentPlanItemInstanceMap.containsKey(planItemDefinitionMapping.getPlanItemDefinitionId())) continue;
            List<PlanItemInstanceEntity> currentPlanItemInstanceList = currentPlanItemInstanceMap.get(planItemDefinitionMapping.getPlanItemDefinitionId());
            for (PlanItemInstanceEntity planItemInstance : currentPlanItemInstanceList) {
                if (PlanItemInstanceState.TERMINAL_STATES.contains(planItemInstance.getState()) || "wait_repetition".equals(planItemInstance.getState())) continue;
                this.terminatePlanItemInstance(planItemInstance, commandContext);
            }
        }
    }

    protected abstract boolean isDirectPlanItemDefinitionMigration(PlanItemDefinition var1, PlanItemDefinition var2);

    protected Map<String, List<PlanItemInstanceEntity>> resolvePlanItemInstances(String caseInstanceId, CaseDefinition caseDefinition, CommandContext commandContext) {
        PlanItemInstanceEntityManager planItemInstanceEntityManager = this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager();
        List<PlanItemInstanceEntity> planItemInstances = planItemInstanceEntityManager.findByCaseInstanceId(caseInstanceId);
        if (caseDefinition != null) {
            TaskService taskService = this.cmmnEngineConfiguration.getTaskServiceConfiguration().getTaskService();
            for (PlanItemInstanceEntity planItemInstance : planItemInstances) {
                TaskEntityImpl task;
                planItemInstance.setCaseDefinitionId(caseDefinition.getId());
                if ("available".equals(planItemInstance.getState()) || !(planItemInstance.getPlanItemDefinition() instanceof HumanTask) || (task = (TaskEntityImpl)((TaskQuery)((TaskQuery)taskService.createTaskQuery(this.cmmnEngineConfiguration.getCommandExecutor(), (AbstractEngineConfiguration)this.cmmnEngineConfiguration).subScopeId(planItemInstance.getId())).scopeType("cmmn")).singleResult()) == null) continue;
                task.setScopeDefinitionId(caseDefinition.getId());
            }
        }
        Map<String, List<PlanItemInstanceEntity>> stagesByPlanItemDefinitionId = planItemInstances.stream().collect(Collectors.groupingBy(PlanItemInstance::getPlanItemDefinitionId));
        return stagesByPlanItemDefinitionId;
    }

    protected boolean isStageContainerOfAnyPlanItemDefinition(String stageId, Collection<MovePlanItemInstanceEntityContainer.PlanItemMoveEntry> moveToPlanItems) {
        Optional<Stage> isUsed = moveToPlanItems.stream().map(MovePlanItemInstanceEntityContainer.PlanItemMoveEntry::getNewPlanItem).map(PlanItem::getPlanItemDefinition).map(CaseElement::getParentStage).filter(Objects::nonNull).filter(elementStage -> elementStage.getId().equals(stageId)).findAny();
        return isUsed.isPresent();
    }

    protected PlanItemInstanceEntity resolveParentPlanItemInstanceToDelete(PlanItemInstanceEntity planItemInstance, List<MovePlanItemInstanceEntityContainer.PlanItemMoveEntry> moveToPlanItems) {
        if (planItemInstance.getStageInstanceId() == null) {
            return null;
        }
        PlanItemInstanceEntity parentPlanItemInstance = planItemInstance.getStagePlanItemInstanceEntity();
        if (!this.isStageContainerOfAnyPlanItemDefinition(parentPlanItemInstance.getPlanItemDefinitionId(), moveToPlanItems)) {
            PlanItemInstanceEntity stageParentExecution = this.resolveParentPlanItemInstanceToDelete(parentPlanItemInstance, moveToPlanItems);
            if (stageParentExecution != null) {
                return stageParentExecution;
            }
            return parentPlanItemInstance;
        }
        return null;
    }

    protected PlanItemInstanceEntity createStagesAndPlanItemInstances(PlanItem planItem, CaseInstanceEntity caseInstance, CaseInstanceChangeState caseInstanceChangeState, CommandContext commandContext) {
        PlanItemInstanceEntityManager planItemInstanceEntityManager = this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager();
        HashMap<String, Stage> stagesToCreate = new HashMap<String, Stage>();
        PlanItemDefinition planItemDefinition = planItem.getPlanItemDefinition();
        Map<String, List<PlanItemInstanceEntity>> runtimePlanItemInstanceMap = caseInstanceChangeState.getRuntimePlanItemInstances();
        for (Stage stage = planItemDefinition.getParentStage(); stage != null; stage = stage.getParentStage()) {
            if (stage.isPlanModel() || caseInstanceChangeState.getCreatedStageInstances().containsKey(stage.getId()) || this.isStageAncestorOfAnyPlanItemInstance(stage.getId(), runtimePlanItemInstanceMap)) continue;
            stagesToCreate.put(stage.getId(), stage);
        }
        for (Stage stageToCreate : stagesToCreate.values()) {
            if (caseInstanceChangeState.getCreatedStageInstances().containsKey(stageToCreate.getId())) continue;
            PlanItemInstanceEntity stageInstance = this.createStageHierarchy(stageToCreate, null, stagesToCreate, caseInstanceChangeState, caseInstance, commandContext);
            caseInstanceChangeState.addCreatedStageInstance(stageToCreate.getId(), stageInstance);
        }
        Object parentPlanItemInstance = null;
        if (planItemDefinition.getParentStage() != null) {
            String parentStageId = planItemDefinition.getParentStage().getId();
            if (caseInstanceChangeState.getCreatedStageInstances().containsKey(parentStageId)) {
                parentPlanItemInstance = caseInstanceChangeState.getCreatedStageInstances().get(parentStageId);
            } else {
                PlanItemInstanceEntity possibleParentPlanItemInstance = caseInstanceChangeState.getRuntimePlanItemInstance(parentStageId);
                if (possibleParentPlanItemInstance != null && "available".equals((parentPlanItemInstance = possibleParentPlanItemInstance).getState())) {
                    parentPlanItemInstance.setState("active");
                    planItemInstanceEntityManager.update((Entity)parentPlanItemInstance);
                    if (!parentPlanItemInstance.getPlanItem().getEntryCriteria().isEmpty() && this.hasRepetitionRule((PlanItemInstanceEntity)parentPlanItemInstance) && this.evaluateRepetitionRule((PlanItemInstanceEntity)parentPlanItemInstance, commandContext)) {
                        this.createPlanItemInstanceDuplicateForRepetition((PlanItemInstanceEntity)parentPlanItemInstance, commandContext);
                    }
                }
            }
        }
        PlanItemInstanceEntity newPlanItemInstance = null;
        for (List<PlanItemInstanceEntity> existingPlanItemInstances : runtimePlanItemInstanceMap.values()) {
            for (PlanItemInstanceEntity existingPlanItemInstance : existingPlanItemInstances) {
                if (!existingPlanItemInstance.getPlanItemDefinitionId().equals(planItemDefinition.getId()) || !"available".equals(existingPlanItemInstance.getState())) continue;
                newPlanItemInstance = existingPlanItemInstance;
            }
        }
        if (newPlanItemInstance == null) {
            newPlanItemInstance = planItemInstanceEntityManager.createPlanItemInstanceEntityBuilder().planItem(planItem).caseDefinitionId(caseInstance.getCaseDefinitionId()).caseInstanceId(caseInstance.getId()).stagePlanItemInstance((PlanItemInstance)parentPlanItemInstance).tenantId(caseInstance.getTenantId()).addToParent(true).create();
            CmmnHistoryManager cmmnHistoryManager = this.cmmnEngineConfiguration.getCmmnHistoryManager();
            cmmnHistoryManager.recordPlanItemInstanceCreated(newPlanItemInstance);
            this.createChildPlanItemInstancesForStage(Collections.singletonList(newPlanItemInstance), Collections.singleton(planItem.getId()), commandContext);
        }
        return newPlanItemInstance;
    }

    protected void createChildPlanItemInstancesForStage(List<PlanItemInstanceEntity> newPlanItemInstances, Set<String> newPlanItemInstanceIds, CommandContext commandContext) {
        if (newPlanItemInstances.size() == 0) {
            return;
        }
        PlanItemInstanceEntity newPlanItemInstance = newPlanItemInstances.get(0);
        PlanItem planItem = newPlanItemInstance.getPlanItem();
        if (planItem.getParentStage() != null) {
            for (PlanItem stagePlanItem : planItem.getParentStage().getPlanItems()) {
                if (newPlanItemInstanceIds.contains(stagePlanItem.getId())) continue;
                PlanItemInstanceEntity parentStagePlanItem = newPlanItemInstance.getStagePlanItemInstanceEntity();
                if (parentStagePlanItem == null && newPlanItemInstance.getStageInstanceId() != null) {
                    parentStagePlanItem = (PlanItemInstance)CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findById(newPlanItemInstance.getStageInstanceId());
                }
                if (!(stagePlanItem.getPlanItemDefinition() instanceof Stage)) continue;
                PlanItemInstanceEntity childStagePlanItemInstance = this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().createPlanItemInstanceEntityBuilder().planItem(stagePlanItem).caseDefinitionId(newPlanItemInstance.getCaseDefinitionId()).caseInstanceId(newPlanItemInstance.getCaseInstanceId()).stagePlanItemInstance((PlanItemInstance)parentStagePlanItem).tenantId(newPlanItemInstance.getTenantId()).addToParent(true).create();
                CommandContextUtil.getAgenda(commandContext).planCreatePlanItemInstanceOperation(childStagePlanItemInstance);
            }
        }
    }

    protected boolean isStageAncestorOfAnyPlanItemInstance(String stageId, Map<String, List<PlanItemInstanceEntity>> planItemInstanceMap) {
        for (List<PlanItemInstanceEntity> planItemInstanceList : planItemInstanceMap.values()) {
            for (PlanItemInstanceEntity planItemInstance : planItemInstanceList) {
                PlanItemDefinition planItemDefinition = planItemInstance.getPlanItem().getPlanItemDefinition();
                if (planItemDefinition.getId().equals(stageId)) {
                    return true;
                }
                if (!this.isStageAncestor(stageId, planItemDefinition)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isStageAncestor(String stageId, PlanItemDefinition planItemDefinition) {
        while (planItemDefinition.getParentStage() != null) {
            String currentStageId = planItemDefinition.getParentStage().getId();
            if (currentStageId != null && currentStageId.equals(stageId)) {
                return true;
            }
            planItemDefinition = planItemDefinition.getParentStage();
        }
        return false;
    }

    protected PlanItemInstanceEntity createStageHierarchy(Stage stage, PlanItemInstanceEntity defaultParentPlanItemInstance, Map<String, Stage> stagesToCreate, CaseInstanceChangeState caseInstanceChangeState, CaseInstanceEntity caseInstance, CommandContext commandContext) {
        PlanItemInstanceEntityManager planItemInstanceEntityManager;
        PlanItemInstanceEntity newPlanItemInstance;
        Map<String, List<PlanItemInstanceEntity>> runtimePlanItemInstanceMap = caseInstanceChangeState.getRuntimePlanItemInstances();
        if (runtimePlanItemInstanceMap.containsKey(stage.getId())) {
            return runtimePlanItemInstanceMap.get(stage.getId()).get(0);
        }
        if (caseInstanceChangeState.getCreatedStageInstances().containsKey(stage.getId())) {
            return caseInstanceChangeState.getCreatedStageInstances().get(stage.getId());
        }
        PlanItemInstanceEntity parentStageInstance = defaultParentPlanItemInstance;
        if (stage.getParentStage() != null && !stage.getParentStage().isPlanModel()) {
            parentStageInstance = this.createStageHierarchy(stage.getParentStage(), defaultParentPlanItemInstance, stagesToCreate, caseInstanceChangeState, caseInstance, commandContext);
            caseInstanceChangeState.getCreatedStageInstances().put(stage.getParentStage().getId(), parentStageInstance);
        }
        if (!(newPlanItemInstance = (planItemInstanceEntityManager = this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager()).createPlanItemInstanceEntityBuilder().planItem(stage.getPlanItem()).caseDefinitionId(caseInstance.getCaseDefinitionId()).caseInstanceId(caseInstance.getId()).stagePlanItemInstance((PlanItemInstance)parentStageInstance).tenantId(caseInstance.getTenantId()).addToParent(true).create()).getPlanItem().getEntryCriteria().isEmpty() && this.hasRepetitionRule(newPlanItemInstance) && this.evaluateRepetitionRule(newPlanItemInstance, commandContext)) {
            this.createPlanItemInstanceDuplicateForRepetition(newPlanItemInstance, commandContext);
        }
        CommandContextUtil.getAgenda(commandContext).planStartPlanItemInstanceOperation(newPlanItemInstance, null);
        return newPlanItemInstance;
    }

    protected void terminatePlanItemInstance(PlanItemInstanceEntity planItemInstance, CommandContext commandContext) {
        String currentPlanItemInstanceState = planItemInstance.getState();
        Date currentTime = this.cmmnEngineConfiguration.getClock().getCurrentTime();
        planItemInstance.setEndedTime(currentTime);
        planItemInstance.setTerminatedTime(currentTime);
        planItemInstance.setState("terminated");
        PlanItemDefinition planItemDefinition = planItemInstance.getPlanItem().getPlanItemDefinition();
        if (planItemDefinition instanceof HumanTask) {
            if ("active".equals(currentPlanItemInstanceState)) {
                TaskService taskService = this.cmmnEngineConfiguration.getTaskServiceConfiguration().getTaskService();
                List taskEntities = taskService.findTasksBySubScopeIdScopeType(planItemInstance.getId(), "cmmn");
                if (taskEntities == null || taskEntities.isEmpty()) {
                    throw new FlowableException("No task entity found for plan item instance " + planItemInstance.getId());
                }
                for (TaskEntity taskEntity : taskEntities) {
                    if (taskEntity.isDeleted()) continue;
                    TaskHelper.deleteTask(taskEntity, "Change plan item state", false, false, this.cmmnEngineConfiguration);
                }
            }
        } else if (planItemDefinition instanceof Stage) {
            this.deleteChildPlanItemInstances(planItemInstance, commandContext);
        } else if (planItemDefinition instanceof ProcessTask && planItemInstance.getReferenceId() != null) {
            this.cmmnEngineConfiguration.getProcessInstanceService().deleteProcessInstance(planItemInstance.getReferenceId());
        }
    }

    protected void deleteChildPlanItemInstances(PlanItemInstanceEntity planItemInstance, CommandContext commandContext) {
        List childPlanItemInstances = planItemInstance.getChildPlanItemInstances();
        if (childPlanItemInstances != null) {
            for (PlanItemInstanceEntity childPlanItemInstance : childPlanItemInstances) {
                this.deleteChildPlanItemInstances(childPlanItemInstance, commandContext);
                this.terminatePlanItemInstance(childPlanItemInstance, commandContext);
            }
        }
    }

    protected void handleHumanTaskNewAssignee(PlanItemInstanceEntity taskPlanItemInstance, String newAssigneeId, CommandContext commandContext) {
        TaskService taskService = this.cmmnEngineConfiguration.getTaskServiceConfiguration().getTaskService();
        TaskEntityImpl task = (TaskEntityImpl)((TaskQuery)((TaskQuery)taskService.createTaskQuery(this.cmmnEngineConfiguration.getCommandExecutor(), (AbstractEngineConfiguration)this.cmmnEngineConfiguration).subScopeId(taskPlanItemInstance.getId())).scopeType("cmmn")).singleResult();
        TaskHelper.changeTaskAssignee((TaskEntity)task, newAssigneeId, this.cmmnEngineConfiguration);
    }

    protected boolean hasRepetitionRule(PlanItemInstanceEntity planItemInstanceEntity) {
        if (planItemInstanceEntity != null && planItemInstanceEntity.getPlanItem() != null) {
            return planItemInstanceEntity.getPlanItem().getItemControl() != null && planItemInstanceEntity.getPlanItem().getItemControl().getRepetitionRule() != null;
        }
        return false;
    }

    protected boolean evaluateRepetitionRule(PlanItemInstanceEntity planItemInstanceEntity, CommandContext commandContext) {
        if (this.hasRepetitionRule(planItemInstanceEntity)) {
            String repetitionCondition = planItemInstanceEntity.getPlanItem().getItemControl().getRepetitionRule().getCondition();
            return this.evaluateRepetitionRule((VariableContainer)planItemInstanceEntity, repetitionCondition, commandContext);
        }
        return false;
    }

    protected boolean evaluateRepetitionRule(VariableContainer variableContainer, String repetitionCondition, CommandContext commandContext) {
        if (StringUtils.isNotEmpty((CharSequence)repetitionCondition)) {
            return ExpressionUtil.evaluateBooleanExpression(commandContext, variableContainer, repetitionCondition);
        }
        return true;
    }

    protected PlanItemInstanceEntity createPlanItemInstanceDuplicateForRepetition(PlanItemInstanceEntity planItemInstanceEntity, CommandContext commandContext) {
        PlanItemInstanceEntity childPlanItemInstanceEntity = this.copyAndInsertPlanItemInstance(commandContext, planItemInstanceEntity, false);
        String oldState = childPlanItemInstanceEntity.getState();
        String newState = "wait_repetition";
        childPlanItemInstanceEntity.setState(newState);
        this.cmmnEngineConfiguration.getListenerNotificationHelper().executeLifecycleListeners(commandContext, planItemInstanceEntity, oldState, newState);
        CommandContextUtil.getAgenda(commandContext).planCreatePlanItemInstanceForRepetitionOperation(childPlanItemInstanceEntity);
        return childPlanItemInstanceEntity;
    }

    protected PlanItemInstanceEntity copyAndInsertPlanItemInstance(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntityToCopy, boolean addToParent) {
        PlanItemInstanceEntity stagePlanItem = planItemInstanceEntityToCopy.getStagePlanItemInstanceEntity();
        if (stagePlanItem == null && planItemInstanceEntityToCopy.getStageInstanceId() != null) {
            stagePlanItem = (PlanItemInstance)this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(planItemInstanceEntityToCopy.getStageInstanceId());
        }
        PlanItemInstanceEntity planItemInstanceEntity = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).createPlanItemInstanceEntityBuilder().planItem(planItemInstanceEntityToCopy.getPlanItem()).caseDefinitionId(planItemInstanceEntityToCopy.getCaseDefinitionId()).caseInstanceId(planItemInstanceEntityToCopy.getCaseInstanceId()).stagePlanItemInstance((PlanItemInstance)stagePlanItem).tenantId(planItemInstanceEntityToCopy.getTenantId()).addToParent(addToParent).create();
        if (this.hasRepetitionRule(planItemInstanceEntityToCopy)) {
            int counter = this.getRepetitionCounter(planItemInstanceEntityToCopy);
            this.setRepetitionCounter(planItemInstanceEntity, counter);
        }
        return planItemInstanceEntity;
    }

    protected int getRepetitionCounter(PlanItemInstanceEntity repeatingPlanItemInstanceEntity) {
        Integer counter = (Integer)repeatingPlanItemInstanceEntity.getVariableLocal(this.getCounterVariable(repeatingPlanItemInstanceEntity));
        if (counter == null) {
            return 0;
        }
        return counter;
    }

    protected void setRepetitionCounter(PlanItemInstanceEntity repeatingPlanItemInstanceEntity, int counterValue) {
        repeatingPlanItemInstanceEntity.setVariableLocal(this.getCounterVariable(repeatingPlanItemInstanceEntity), counterValue);
    }

    protected String getCounterVariable(PlanItemInstanceEntity repeatingPlanItemInstanceEntity) {
        String repetitionCounterVariableName = repeatingPlanItemInstanceEntity.getPlanItem().getItemControl().getRepetitionRule().getRepetitionCounterVariableName();
        return repetitionCounterVariableName;
    }

    protected boolean isExpression(String variableName) {
        return variableName.startsWith("${") || variableName.startsWith("#{");
    }

    protected CaseDefinition resolveCaseDefinition(String caseDefinitionKey, Integer caseDefinitionVersion, String tenantId, CommandContext commandContext) {
        CaseDefinitionEntityManager caseDefinitionEntityManager = CommandContextUtil.getCaseDefinitionEntityManager(commandContext);
        Object caseDefinition = null;
        caseDefinition = caseDefinitionVersion != null ? caseDefinitionEntityManager.findCaseDefinitionByKeyAndVersionAndTenantId(caseDefinitionKey, caseDefinitionVersion, tenantId) : (tenantId == null || "".equals(tenantId) ? caseDefinitionEntityManager.findLatestCaseDefinitionByKey(caseDefinitionKey) : caseDefinitionEntityManager.findLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, tenantId));
        if (caseDefinition == null) {
            CmmnDeploymentManager deploymentManager = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getDeploymentManager();
            caseDefinition = tenantId == null || "".equals(tenantId) ? deploymentManager.findDeployedLatestCaseDefinitionByKey(caseDefinitionKey) : deploymentManager.findDeployedLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, tenantId);
        }
        return caseDefinition;
    }

    protected String getCaseDefinitionIdToMigrateTo(CaseInstanceChangeState caseInstanceChangeState) {
        String caseDefinitionIdToMigrateTo = null;
        if (caseInstanceChangeState.getCaseDefinitionToMigrateTo() != null) {
            caseDefinitionIdToMigrateTo = caseInstanceChangeState.getCaseDefinitionToMigrateTo().getId();
        }
        return caseDefinitionIdToMigrateTo;
    }
}

