/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.interceptor;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.util.IdentityLinkUtil;
import org.flowable.cmmn.engine.interceptor.CmmnIdentityLinkInterceptor;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.api.Task;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class DefaultCmmnIdentityLinkInterceptor
implements CmmnIdentityLinkInterceptor {
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public DefaultCmmnIdentityLinkInterceptor(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    @Override
    public void handleCompleteTask(TaskEntity task) {
        String userId = Authentication.getAuthenticatedUserId();
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            this.addUserIdentityLinkToParent((Task)task, userId);
        }
    }

    @Override
    public void handleAddIdentityLinkToTask(TaskEntity taskEntity, IdentityLinkEntity identityLinkEntity) {
        this.addUserIdentityLinkToParent((Task)taskEntity, identityLinkEntity.getUserId());
    }

    @Override
    public void handleAddAssigneeIdentityLinkToTask(TaskEntity taskEntity, String assignee) {
        this.addUserIdentityLinkToParent((Task)taskEntity, assignee);
    }

    @Override
    public void handleAddOwnerIdentityLinkToTask(TaskEntity taskEntity, String owner) {
        this.addUserIdentityLinkToParent((Task)taskEntity, owner);
    }

    @Override
    public void handleCreateCaseInstance(CaseInstanceEntity caseInstance) {
        String authenticatedUserId = Authentication.getAuthenticatedUserId();
        if (authenticatedUserId != null) {
            IdentityLinkUtil.createCaseInstanceIdentityLink(caseInstance, authenticatedUserId, null, "starter", this.cmmnEngineConfiguration);
        }
    }

    protected void addUserIdentityLinkToParent(Task task, String userId) {
        CaseInstanceEntity caseInstanceEntity;
        if (userId != null && "cmmn".equals(task.getScopeType()) && StringUtils.isNotEmpty((CharSequence)task.getScopeId()) && (caseInstanceEntity = (CaseInstanceEntity)this.cmmnEngineConfiguration.getCaseInstanceEntityManager().findById(task.getScopeId())) != null) {
            List identityLinks = this.cmmnEngineConfiguration.getIdentityLinkServiceConfiguration().getIdentityLinkService().findIdentityLinksByScopeIdAndType(caseInstanceEntity.getId(), "cmmn");
            for (IdentityLinkEntity identityLink : identityLinks) {
                if (!identityLink.isUser() || !identityLink.getUserId().equals(userId) || !"participant".equals(identityLink.getType())) continue;
                return;
            }
            IdentityLinkUtil.createCaseInstanceIdentityLink(caseInstanceEntity, userId, null, "participant", this.cmmnEngineConfiguration);
        }
    }
}

