/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.flowable.cmmn.engine.impl.agenda.operation.AbstractDeleteCaseInstanceOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.CompletionEvaluationResult;
import org.flowable.cmmn.engine.impl.util.PlanItemInstanceContainerUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class TerminateCaseInstanceOperation
extends AbstractDeleteCaseInstanceOperation {
    protected boolean manualTermination;
    protected String exitCriterionId;
    protected String exitType;
    protected String exitEventType;

    public TerminateCaseInstanceOperation(CommandContext commandContext, String caseInstanceId, boolean manualTermination, String exitCriterionId, String exitType, String exitEventType) {
        super(commandContext, caseInstanceId);
        this.manualTermination = manualTermination;
        this.exitCriterionId = exitCriterionId;
        this.exitType = exitType;
        this.exitEventType = exitEventType;
    }

    @Override
    public void run() {
        if ("complete".equals(this.exitEventType)) {
            this.checkCaseToBeCompletable();
        }
        super.run();
    }

    protected void checkCaseToBeCompletable() {
        CaseInstanceEntity caseInstance = this.getCaseInstanceEntity();
        boolean isAutoComplete = this.getPlanModel(caseInstance).isAutoComplete();
        CompletionEvaluationResult completionEvaluationResult = PlanItemInstanceContainerUtil.shouldPlanItemContainerComplete(this.commandContext, caseInstance, true);
        if (!completionEvaluationResult.isCompletable()) {
            throw new FlowableIllegalArgumentException("Cannot exit case with 'complete' event type as the case '" + this.getCaseInstanceId() + "' is not yet completable. The plan item '" + completionEvaluationResult.getPlanItemInstance().getName() + " (" + completionEvaluationResult.getPlanItemInstance().getPlanItemDefinitionId() + ")' prevented it from completion.");
        }
    }

    @Override
    public String getNewState() {
        if ("complete".equals(this.exitEventType) || "forceComplete".equals(this.exitEventType)) {
            return "completed";
        }
        return "terminated";
    }

    @Override
    protected void changeStateForChildPlanItemInstance(PlanItemInstanceEntity planItemInstanceEntity) {
        if (this.manualTermination) {
            CommandContextUtil.getAgenda(this.commandContext).planTerminatePlanItemInstanceOperation(planItemInstanceEntity, null, null);
        } else {
            CommandContextUtil.getAgenda(this.commandContext).planExitPlanItemInstanceOperation(planItemInstanceEntity, this.exitCriterionId, null, null);
        }
    }

    @Override
    public String getDeleteReason() {
        return "cmmn-state-transition-terminate-case";
    }

    public boolean isManualTermination() {
        return this.manualTermination;
    }

    public void setManualTermination(boolean manualTermination) {
        this.manualTermination = manualTermination;
    }

    public String getExitCriterionId() {
        return this.exitCriterionId;
    }

    public void setExitCriterionId(String exitCriterionId) {
        this.exitCriterionId = exitCriterionId;
    }

    public String getExitType() {
        return this.exitType;
    }

    public void setExitType(String exitType) {
        this.exitType = exitType;
    }

    public String getExitEventType() {
        return this.exitEventType;
    }

    public void setExitEventType(String exitEventType) {
        this.exitEventType = exitEventType;
    }
}

