/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.List;
import java.util.Objects;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceState;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangePlanItemInstanceStateOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.runtime.StateTransition;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public abstract class AbstractMovePlanItemInstanceToTerminalStateOperation
extends AbstractChangePlanItemInstanceStateOperation {
    public AbstractMovePlanItemInstanceToTerminalStateOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        super(commandContext, planItemInstanceEntity);
    }

    @Override
    public void run() {
        String originalState = this.planItemInstanceEntity.getState();
        super.run();
        if (!this.isNoop) {
            String plannedNewState = this.getNewState();
            if (this.isRepeatingOnDelete(originalState, plannedNewState) && !this.isWaitingForRepetitionPlanItemInstanceExists(this.planItemInstanceEntity)) {
                PlanItemInstanceEntity newPlanItemInstanceEntity = this.copyAndInsertPlanItemInstance(this.commandContext, this.planItemInstanceEntity, true, false);
                if (this.planItemInstanceEntity.getPlanItem() != null && this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition() instanceof EventListener) {
                    CommandContextUtil.getAgenda(this.commandContext).planCreatePlanItemInstanceOperation(newPlanItemInstanceEntity);
                } else {
                    String oldState = newPlanItemInstanceEntity.getState();
                    String newState = "wait_repetition";
                    newPlanItemInstanceEntity.setState(newState);
                    CommandContextUtil.getCmmnEngineConfiguration(this.commandContext).getListenerNotificationHelper().executeLifecycleListeners(this.commandContext, newPlanItemInstanceEntity, oldState, newState);
                    CommandContextUtil.getAgenda(this.commandContext).planCreatePlanItemInstanceForRepetitionOperation(newPlanItemInstanceEntity);
                    if (this.hasRepetitionRuleAndNoEntryCriteria(this.planItemInstanceEntity.getPlanItem())) {
                        CommandContextUtil.getAgenda(this.commandContext).planActivatePlanItemInstanceOperation(newPlanItemInstanceEntity, null);
                    }
                }
            }
            this.removeSentryRelatedData();
        }
    }

    @Override
    protected abstract void internalExecute();

    public boolean isRepeatingOnDelete(String originalState, String newState) {
        CaseInstanceEntity caseInstance = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(this.commandContext).findById(this.planItemInstanceEntity.getCaseInstanceId());
        if (CaseInstanceState.isInTerminalState((CaseInstance)caseInstance)) {
            return false;
        }
        PlanItem planItem = this.planItemInstanceEntity.getPlanItem();
        if (this.isEvaluateRepetitionRule() && this.hasRepetitionRuleAndNoEntryCriteria(planItem)) {
            return ExpressionUtil.evaluateRepetitionRule(this.commandContext, this.planItemInstanceEntity, this.planItemInstanceEntity.getStagePlanItemInstanceEntity());
        }
        return "available".equals(originalState) && "terminated".equals(newState) && this.hasRepetitionRuleEntryCriteria(planItem) && !this.hasRepetitionOnCollection(planItem) && this.isWithoutStageOrParentIsNotTerminated(this.planItemInstanceEntity);
    }

    public boolean isWithoutStageOrParentIsNotTerminated(PlanItemInstanceEntity planItemInstanceEntity) {
        return planItemInstanceEntity.getStagePlanItemInstanceEntity() == null || !PlanItemInstanceState.isInTerminalState((PlanItemInstance)planItemInstanceEntity.getStagePlanItemInstanceEntity());
    }

    public boolean hasRepetitionRuleAndNoEntryCriteria(PlanItem planItem) {
        return planItem != null && planItem.getEntryCriteria().isEmpty() && planItem.getItemControl() != null && planItem.getItemControl().getRepetitionRule() != null && !planItem.getItemControl().getRepetitionRule().hasCollectionVariable();
    }

    public boolean hasRepetitionOnCollection(PlanItem planItem) {
        return planItem != null && planItem.getItemControl() != null && planItem.getItemControl().getRepetitionRule() != null && planItem.getItemControl().getRepetitionRule().hasCollectionVariable();
    }

    public boolean hasRepetitionRuleEntryCriteria(PlanItem planItem) {
        return planItem != null && !planItem.getEntryCriteria().isEmpty() && planItem.getItemControl() != null && planItem.getItemControl().getRepetitionRule() != null;
    }

    public boolean isWaitingForRepetitionPlanItemInstanceExists(PlanItemInstanceEntity planItemInstanceEntity) {
        List childPlanItemInstances;
        PlanItemInstanceEntity stagePlanItemInstanceEntity = planItemInstanceEntity.getStagePlanItemInstanceEntity();
        if (stagePlanItemInstanceEntity != null && (childPlanItemInstances = stagePlanItemInstanceEntity.getChildPlanItemInstances()) != null && !childPlanItemInstances.isEmpty()) {
            return childPlanItemInstances.stream().anyMatch(p -> Objects.equals(p.getPlanItem().getId(), planItemInstanceEntity.getPlanItem().getId()) && "wait_repetition".equals(p.getState()));
        }
        return false;
    }

    protected void completeChildPlanItemInstances() {
        this.completeChildPlanItemInstances(null);
    }

    protected void completeChildPlanItemInstances(String exitCriterionId) {
        for (PlanItemInstanceEntity child : this.planItemInstanceEntity.getChildPlanItemInstances()) {
            if (!StateTransition.isPossible((PlanItemInstance)child, "complete")) continue;
            CommandContextUtil.getAgenda(this.commandContext).planCompletePlanItemInstanceOperation(child);
        }
    }

    protected void exitChildPlanItemInstances() {
        this.exitChildPlanItemInstances(null);
    }

    protected void exitChildPlanItemInstances(String exitCriterionId) {
        for (PlanItemInstanceEntity child : this.planItemInstanceEntity.getChildPlanItemInstances()) {
            if (!StateTransition.isPossible((PlanItemInstance)child, "exit")) continue;
            CommandContextUtil.getAgenda(this.commandContext).planExitPlanItemInstanceOperation(child, exitCriterionId, null, null);
        }
    }

    public abstract boolean isEvaluateRepetitionRule();
}

