/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.test;

import java.time.Instant;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.CmmnTaskService;
import org.flowable.cmmn.api.DynamicCmmnService;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceQuery;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.test.impl.CmmnJobTestHelper;
import org.flowable.cmmn.engine.test.impl.CmmnTestRunner;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=CmmnTestRunner.class)
public abstract class AbstractFlowableCmmnTestCase {
    public static CmmnEngine cmmnEngine;
    protected CmmnEngineConfiguration cmmnEngineConfiguration;
    protected CmmnManagementService cmmnManagementService;
    protected CmmnRepositoryService cmmnRepositoryService;
    protected CmmnRuntimeService cmmnRuntimeService;
    protected DynamicCmmnService dynamicCmmnService;
    protected CmmnTaskService cmmnTaskService;
    protected CmmnHistoryService cmmnHistoryService;
    protected String deploymentId;

    @After
    public void cleanup() {
        if (this.deploymentId != null) {
            this.cmmnRepositoryService.deleteDeployment(this.deploymentId, true);
        }
    }

    protected void deployOneHumanTaskCaseModel() {
        this.deploymentId = this.cmmnRepositoryService.createDeployment().addClasspathResource("org/flowable/cmmn/test/one-human-task-model.cmmn").deploy().getId();
    }

    protected CaseInstance deployAndStartOneHumanTaskCaseModel() {
        this.deployOneHumanTaskCaseModel();
        return this.cmmnRuntimeService.createCaseInstanceBuilder().caseDefinitionKey("oneTaskCase").start();
    }

    protected void deployOneTaskCaseModel() {
        this.deploymentId = this.cmmnRepositoryService.createDeployment().addClasspathResource("org/flowable/cmmn/test/one-task-model.cmmn").deploy().getId();
    }

    protected Date setClockFixedToCurrentTime() {
        Date date = Date.from(Instant.now().with(ChronoField.MILLI_OF_SECOND, 0L));
        this.cmmnEngineConfiguration.getClock().setCurrentTime(date);
        return date;
    }

    protected void setClockTo(long epochTime) {
        this.setClockTo(new Date(epochTime));
    }

    protected void setClockTo(Date date) {
        this.cmmnEngineConfiguration.getClock().setCurrentTime(date);
    }

    protected Date forwardClock(long milliseconds) {
        long currentMillis = this.cmmnEngineConfiguration.getClock().getCurrentTime().getTime();
        Date date = new Date(currentMillis + milliseconds);
        this.cmmnEngineConfiguration.getClock().setCurrentTime(date);
        return date;
    }

    protected void assertCaseInstanceEnded(CaseInstance caseInstance) {
        long count = this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstance.getId()).count();
        Assert.assertEquals((String)this.createCaseInstanceEndedErrorMessage(caseInstance, count), (long)0L, (long)count);
        Assert.assertEquals((String)"Runtime case instance found", (long)0L, (long)this.cmmnRuntimeService.createCaseInstanceQuery().caseInstanceId(caseInstance.getId()).count());
        Assert.assertEquals((long)1L, (long)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstance.getId()).finished().count());
    }

    protected String createCaseInstanceEndedErrorMessage(CaseInstance caseInstance, long count) {
        String errorMessage = "Plan item instances found for case instance: ";
        if (count != 0L) {
            List planItemInstances = this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstance.getId()).list();
            String names = planItemInstances.stream().map(planItemInstance -> planItemInstance.getName() + "(" + planItemInstance.getPlanItemDefinitionType() + ")").collect(Collectors.joining(", "));
            errorMessage = errorMessage + names;
        }
        return errorMessage;
    }

    protected void assertCaseInstanceEnded(CaseInstance caseInstance, int nrOfExpectedMilestones) {
        this.assertCaseInstanceEnded(caseInstance);
        Assert.assertEquals((long)0L, (long)this.cmmnRuntimeService.createMilestoneInstanceQuery().milestoneInstanceCaseInstanceId(caseInstance.getId()).count());
        Assert.assertEquals((long)nrOfExpectedMilestones, (long)this.cmmnHistoryService.createHistoricMilestoneInstanceQuery().milestoneInstanceCaseInstanceId(caseInstance.getId()).count());
    }

    protected void assertCaseInstanceNotEnded(CaseInstance caseInstance) {
        Assert.assertTrue((String)"Found no plan items for case instance", (this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstance.getId()).count() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"No runtime case instance found", (this.cmmnRuntimeService.createCaseInstanceQuery().caseInstanceId(caseInstance.getId()).count() > 0L ? 1 : 0) != 0);
        Assert.assertNull((String)"Historical case instance is already marked as ended", (Object)((HistoricCaseInstance)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstance.getId()).singleResult()).getEndTime());
    }

    protected void assertSingleTaskExists(List<Task> tasks, String name) {
        List taskIds = tasks.stream().filter(task -> Objects.equals(name, task.getName())).map(TaskInfo::getId).collect(Collectors.toList());
        Assert.assertNotNull(taskIds);
        Assert.assertEquals((long)1L, (long)taskIds.size());
    }

    protected void assertPlanItemInstanceState(CaseInstance caseInstance, String name, String ... states) {
        List planItemInstances = ((PlanItemInstanceQuery)this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstance.getId()).orderByName().asc()).includeEnded().list();
        this.assertPlanItemInstanceState(planItemInstances, name, states);
    }

    protected void assertPlanItemInstanceState(List<PlanItemInstance> planItemInstances, String name, String ... states) {
        List planItemInstanceStates = planItemInstances.stream().filter(planItemInstance -> Objects.equals(name, planItemInstance.getName())).map(PlanItemInstance::getState).collect(Collectors.toList());
        if (planItemInstanceStates.isEmpty()) {
            Assert.fail((String)("No plan item instances found with name " + name));
        }
        Assert.assertEquals((String)("Incorrect number of states found: " + planItemInstanceStates + ""), (long)states.length, (long)planItemInstanceStates.size());
        ArrayList originalStates = new ArrayList(planItemInstanceStates);
        for (String state : states) {
            Assert.assertTrue((String)("State '" + state + "' not found in plan item instances states '" + originalStates + "'"), (boolean)planItemInstanceStates.remove(state));
        }
    }

    protected void assertNoPlanItemInstance(List<PlanItemInstance> planItemInstances, String name) {
        List planItemInstanceStates = planItemInstances.stream().filter(planItemInstance -> Objects.equals(name, planItemInstance.getName())).map(PlanItemInstance::getState).collect(Collectors.toList());
        if (!planItemInstanceStates.isEmpty()) {
            Assert.fail((String)(planItemInstanceStates.size() + " plan item instance(s) found with name " + name + ", but should be 0"));
        }
    }

    protected void assertPlanItemLocalVariables(String caseInstanceId, String planItemName, List<?> itemVariableValues, List<Integer> itemIndexVariableValues) {
        List tasks = ((PlanItemInstanceQuery)this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstanceId).planItemInstanceName(planItemName).planItemInstanceStateActive().orderByCreateTime().asc()).list();
        Assert.assertEquals((long)itemVariableValues.size(), (long)tasks.size());
        ArrayList<Object> itemValues = new ArrayList<Object>(tasks.size());
        ArrayList<Object> itemIndexValues = new ArrayList<Object>(tasks.size());
        for (PlanItemInstance task : tasks) {
            itemValues.add(this.cmmnRuntimeService.getLocalVariable(task.getId(), "item"));
            itemIndexValues.add(this.cmmnRuntimeService.getLocalVariable(task.getId(), "itemIndex"));
        }
        for (int ii = 0; ii < itemVariableValues.size(); ++ii) {
            int index = this.searchForMatch(itemVariableValues.get(ii), itemIndexVariableValues.get(ii), itemValues, itemIndexValues);
            if (index == -1) {
                Assert.fail((String)("Could not find local variable value '" + itemVariableValues.get(ii) + "' with index value '" + itemIndexVariableValues.get(ii) + "'."));
            }
            itemValues.remove(index);
            itemIndexValues.remove(index);
        }
    }

    protected int searchForMatch(Object itemValue, Integer index, List<Object> itemValues, List<Object> itemIndexValues) {
        for (int ii = 0; ii < itemValues.size(); ++ii) {
            if (!itemValues.get(ii).equals(itemValue) || !itemIndexValues.get(ii).equals(index)) continue;
            return ii;
        }
        return -1;
    }

    protected void completePlanItemsWithItemValues(String caseInstanceId, String planItemName, int expectedTotalCount, Object ... itemValues) {
        List tasks = ((PlanItemInstanceQuery)this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstanceId).planItemInstanceName(planItemName).planItemInstanceStateActive().orderByCreateTime().asc()).list();
        Assert.assertEquals((long)expectedTotalCount, (long)tasks.size());
        Assert.assertNotNull((Object)itemValues);
        Assert.assertTrue((itemValues.length <= expectedTotalCount ? 1 : 0) != 0);
        for (Object itemValue : itemValues) {
            if (this.completePlanItemWithItemValue(tasks, itemValue)) continue;
            Assert.fail((String)("Could not find plan item instance with 'item' value of '" + itemValue + "'"));
        }
    }

    protected boolean completePlanItemWithItemValue(List<PlanItemInstance> planItemInstances, Object itemValue) {
        for (PlanItemInstance planItemInstance : planItemInstances) {
            Object itemValueVar = this.cmmnRuntimeService.getLocalVariable(planItemInstance.getId(), "item");
            if (!itemValue.equals(itemValueVar)) continue;
            this.cmmnRuntimeService.triggerPlanItemInstance(planItemInstance.getId());
            return true;
        }
        return false;
    }

    protected void completeAllPlanItems(String caseInstanceId, String planItemName, int expectedCount) {
        List tasks = ((PlanItemInstanceQuery)this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstanceId).planItemInstanceName(planItemName).planItemInstanceStateActive().orderByCreateTime().asc()).list();
        Assert.assertEquals((long)expectedCount, (long)tasks.size());
        for (PlanItemInstance task : tasks) {
            this.cmmnRuntimeService.triggerPlanItemInstance(task.getId());
        }
    }

    protected List<PlanItemInstance> getAllPlanItemInstances(String caseInstanceId) {
        return ((PlanItemInstanceQuery)((PlanItemInstanceQuery)this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstanceId).orderByName().asc()).orderByEndTime().asc()).includeEnded().list();
    }

    protected List<PlanItemInstance> getPlanItemInstances(String caseInstanceId) {
        return ((PlanItemInstanceQuery)this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstanceId).orderByName().asc()).list();
    }

    protected List<PlanItemInstance> getCompletedPlanItemInstances(String caseInstanceId) {
        return ((PlanItemInstanceQuery)this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstanceId).planItemInstanceStateCompleted().includeEnded().orderByName().asc()).list();
    }

    protected List<PlanItemInstance> getTerminatedPlanItemInstances(String caseInstanceId) {
        return ((PlanItemInstanceQuery)this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstanceId).orderByName().asc()).planItemInstanceStateTerminated().includeEnded().list();
    }

    protected String getPlanItemInstanceIdByName(List<PlanItemInstance> planItemInstances, String name) {
        return this.getPlanItemInstanceByName(planItemInstances, name, null).getId();
    }

    protected String getPlanItemInstanceIdByNameAndState(List<PlanItemInstance> planItemInstances, String name, String state) {
        return this.getPlanItemInstanceByName(planItemInstances, name, state).getId();
    }

    protected PlanItemInstance getPlanItemInstanceByName(List<PlanItemInstance> planItemInstances, String name, String state) {
        List matchingPlanItemInstances = planItemInstances.stream().filter(planItemInstance -> Objects.equals(name, planItemInstance.getName())).filter(planItemInstance -> state != null ? Objects.equals(state, planItemInstance.getState()) : true).collect(Collectors.toList());
        if (matchingPlanItemInstances.isEmpty()) {
            Assert.fail((String)("No plan item instances found with name " + name));
        }
        if (matchingPlanItemInstances.size() > 1) {
            Assert.fail((String)("Found " + matchingPlanItemInstances.size() + " plan item instances with name " + name));
        }
        return (PlanItemInstance)matchingPlanItemInstances.get(0);
    }

    protected void waitForJobExecutorToProcessAllJobs() {
        CmmnJobTestHelper.waitForJobExecutorToProcessAllJobs(this.cmmnEngineConfiguration, 20000L, 200L, true);
    }

    protected void waitForAsyncHistoryExecutorToProcessAllJobs() {
        CmmnJobTestHelper.waitForAsyncHistoryExecutorToProcessAllJobs(this.cmmnEngineConfiguration, 20000L, 200L, true);
    }
}

