/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.task.api.Task;
import org.flowable.task.service.event.impl.FlowableTaskEventBuilder;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class SaveTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected TaskEntity task;

    public SaveTaskCmd(Task task) {
        this.task = (TaskEntity)task;
    }

    public Void execute(CommandContext commandContext) {
        if (this.task == null) {
            throw new FlowableIllegalArgumentException("task is null");
        }
        if (this.task.getRevision() == 0) {
            TaskHelper.insertTask(this.task, true);
            CommandContextUtil.getCmmnHistoryManager().recordTaskCreated(this.task);
            if (CommandContextUtil.getEventDispatcher() != null && CommandContextUtil.getEventDispatcher().isEnabled()) {
                CommandContextUtil.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.TASK_CREATED, (Object)this.task));
            }
        } else {
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
            TaskEntity originalTaskEntity = CommandContextUtil.getTaskService().getTask(this.task.getId());
            if (originalTaskEntity == null && cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
                originalTaskEntity = CommandContextUtil.getHistoricTaskService().getHistoricTask(this.task.getId());
            }
            String originalAssignee = originalTaskEntity.getAssignee();
            CommandContextUtil.getCmmnHistoryManager(commandContext).recordTaskInfoChange(this.task, cmmnEngineConfiguration.getClock().getCurrentTime());
            CommandContextUtil.getTaskService().updateTask(this.task, true);
            if (!StringUtils.equals((CharSequence)originalAssignee, (CharSequence)this.task.getAssignee())) {
                CommandContextUtil.getCmmnEngineConfiguration(commandContext).getListenerNotificationHelper().executeTaskListeners(this.task, "assignment");
                if (CommandContextUtil.getEventDispatcher() != null && CommandContextUtil.getEventDispatcher().isEnabled()) {
                    CommandContextUtil.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.TASK_ASSIGNED, (Object)this.task));
                }
            }
        }
        return null;
    }
}

