/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangePlanItemInstanceStateOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class EnablePlanItemInstanceOperation
extends AbstractChangePlanItemInstanceStateOperation {
    protected String entryCriterionId;

    public EnablePlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId) {
        super(commandContext, planItemInstanceEntity);
        this.entryCriterionId = entryCriterionId;
    }

    @Override
    protected String getLifeCycleTransition() {
        return "enable";
    }

    @Override
    protected String getNewState() {
        return "enabled";
    }

    @Override
    protected void internalExecute() {
        this.removeSentryRelatedData();
        this.planItemInstanceEntity.setEntryCriterionId(this.entryCriterionId);
        this.planItemInstanceEntity.setLastEnabledTime(this.getCurrentTime(this.commandContext));
        CommandContextUtil.getCmmnHistoryManager(this.commandContext).recordPlanItemInstanceEnabled(this.planItemInstanceEntity);
    }

    @Override
    protected String getOperationName() {
        return "[Enable plan item]";
    }
}

