/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceContainer;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public abstract class CmmnOperation
implements Runnable {
    protected CommandContext commandContext;
    protected boolean isNoop = false;

    public CmmnOperation() {
    }

    public CmmnOperation(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    public abstract String getCaseInstanceId();

    protected Stage getStage(PlanItemInstanceEntity planItemInstanceEntity) {
        PlanItemDefinition planItemDefinition = planItemInstanceEntity.getPlanItem().getPlanItemDefinition();
        if (planItemDefinition instanceof Stage) {
            return (Stage)planItemDefinition;
        }
        return planItemDefinition.getParentStage();
    }

    protected boolean isStage(PlanItemInstanceEntity planItemInstanceEntity) {
        return planItemInstanceEntity.getPlanItem() != null && planItemInstanceEntity.getPlanItem().getPlanItemDefinition() != null && planItemInstanceEntity.getPlanItem().getPlanItemDefinition() instanceof Stage;
    }

    protected Stage getPlanModel(CaseInstanceEntity caseInstanceEntity) {
        return CaseDefinitionUtil.getCase(caseInstanceEntity.getCaseDefinitionId()).getPlanModel();
    }

    protected List<PlanItemInstanceEntity> createPlanItemInstancesForNewStage(CommandContext commandContext, List<PlanItem> planItems, String caseDefinitionId, CaseInstanceEntity caseInstanceEntity, PlanItemInstanceEntity stagePlanItemInstanceEntity, String tenantId) {
        ArrayList<PlanItemInstanceEntity> planItemInstances = new ArrayList<PlanItemInstanceEntity>();
        for (PlanItem planItem : planItems) {
            if (stagePlanItemInstanceEntity != null && this.childPlanItemInstanceForPlanItemExists(stagePlanItemInstanceEntity, planItem)) continue;
            String caseInstanceId = null;
            if (caseInstanceEntity != null) {
                caseInstanceId = caseInstanceEntity.getId();
            } else if (stagePlanItemInstanceEntity != null) {
                caseInstanceId = stagePlanItemInstanceEntity.getCaseInstanceId();
            }
            PlanItemInstanceEntity childPlanItemInstance = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).createPlanItemInstanceEntityBuilder().planItem(planItem).caseDefinitionId(caseDefinitionId).caseInstanceId(caseInstanceId).stagePlanItemInstance((PlanItemInstance)stagePlanItemInstanceEntity).tenantId(tenantId).addToParent(true).silentNameExpressionEvaluation(ExpressionUtil.hasRepetitionOnCollection(planItem)).create();
            planItemInstances.add(childPlanItemInstance);
            CommandContextUtil.getAgenda(commandContext).planCreatePlanItemInstanceOperation(childPlanItemInstance);
        }
        return planItemInstances;
    }

    protected boolean childPlanItemInstanceForPlanItemExists(PlanItemInstanceContainer planItemInstanceContainer, PlanItem planItem) {
        List<PlanItemInstanceEntity> childPlanItemInstances = planItemInstanceContainer.getChildPlanItemInstances();
        if (childPlanItemInstances != null && !childPlanItemInstances.isEmpty()) {
            for (PlanItemInstanceEntity childPlanItemInstanceEntity : childPlanItemInstances) {
                if (childPlanItemInstanceEntity.getPlanItem() == null || !planItem.getId().equals(childPlanItemInstanceEntity.getPlanItem().getId())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isEventListenerWithAvailableCondition(PlanItem planItem) {
        if (planItem.getPlanItemDefinition() != null && planItem.getPlanItemDefinition() instanceof EventListener) {
            EventListener eventListener = (EventListener)planItem.getPlanItemDefinition();
            return StringUtils.isNotEmpty((CharSequence)eventListener.getAvailableConditionExpression());
        }
        return false;
    }

    protected PlanItemInstanceEntity copyAndInsertPlanItemInstance(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntityToCopy, boolean addToParent, boolean silentNameExpressionEvaluation) {
        return this.copyAndInsertPlanItemInstance(commandContext, planItemInstanceEntityToCopy, null, addToParent, silentNameExpressionEvaluation);
    }

    protected PlanItemInstanceEntity copyAndInsertPlanItemInstance(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntityToCopy, Map<String, Object> localVariables, boolean addToParent, boolean silentNameExpressionEvaluation) {
        PlanItemInstanceEntity stagePlanItem;
        if (ExpressionUtil.hasRepetitionRule(planItemInstanceEntityToCopy)) {
            int counter = this.getRepetitionCounter(planItemInstanceEntityToCopy);
            if (localVariables == null) {
                localVariables = new HashMap<String, Object>(0);
            }
            localVariables.put(this.getCounterVariable(planItemInstanceEntityToCopy), counter);
        }
        if ((stagePlanItem = planItemInstanceEntityToCopy.getStagePlanItemInstanceEntity()) == null && planItemInstanceEntityToCopy.getStageInstanceId() != null) {
            stagePlanItem = (PlanItemInstance)CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findById(planItemInstanceEntityToCopy.getStageInstanceId());
        }
        PlanItemInstanceEntity planItemInstanceEntity = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).createPlanItemInstanceEntityBuilder().planItem(planItemInstanceEntityToCopy.getPlanItem()).caseDefinitionId(planItemInstanceEntityToCopy.getCaseDefinitionId()).caseInstanceId(planItemInstanceEntityToCopy.getCaseInstanceId()).stagePlanItemInstance((PlanItemInstance)stagePlanItem).tenantId(planItemInstanceEntityToCopy.getTenantId()).localVariables(localVariables).addToParent(addToParent).silentNameExpressionEvaluation(silentNameExpressionEvaluation).create();
        return planItemInstanceEntity;
    }

    protected int getRepetitionCounter(PlanItemInstanceEntity repeatingPlanItemInstanceEntity) {
        Integer counter = (Integer)repeatingPlanItemInstanceEntity.getVariableLocal(this.getCounterVariable(repeatingPlanItemInstanceEntity));
        if (counter == null) {
            return 0;
        }
        return counter;
    }

    protected void setRepetitionCounter(PlanItemInstanceEntity repeatingPlanItemInstanceEntity, int counterValue) {
        repeatingPlanItemInstanceEntity.setVariableLocal(this.getCounterVariable(repeatingPlanItemInstanceEntity), counterValue);
    }

    protected String getCounterVariable(PlanItemInstanceEntity repeatingPlanItemInstanceEntity) {
        String repetitionCounterVariableName = repeatingPlanItemInstanceEntity.getPlanItem().getItemControl().getRepetitionRule().getRepetitionCounterVariableName();
        return repetitionCounterVariableName;
    }

    public void markAsNoop() {
        this.isNoop = true;
    }

    public boolean isNoop() {
        return this.isNoop;
    }
}

