/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import org.flowable.cmmn.engine.impl.cmd.NeedsActiveTaskCmd;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableTaskAlreadyClaimedException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.runtime.Clock;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class ClaimTaskCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    protected String userId;

    public ClaimTaskCmd(String taskId, String userId) {
        super(taskId);
        this.userId = userId;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (this.userId != null) {
            Clock clock = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getClock();
            task.setClaimTime(clock.getCurrentTime());
            if (task.getAssignee() != null) {
                if (!task.getAssignee().equals(this.userId)) {
                    throw new FlowableTaskAlreadyClaimedException(task.getId(), task.getAssignee());
                }
                CommandContextUtil.getCmmnHistoryManager(commandContext).recordTaskInfoChange(task, clock.getCurrentTime());
            } else {
                TaskHelper.changeTaskAssignee(task, this.userId);
            }
        } else if (task.getAssignee() != null) {
            task.setClaimTime(null);
            TaskHelper.changeTaskAssignee(task, null);
        }
        return null;
    }

    @Override
    protected String getSuspendedTaskException() {
        return "Cannot claim a suspended task";
    }
}

