/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public abstract class AbstractNeedsPlanItemInstanceCmd
implements Command<Void>,
Serializable {
    protected String planItemInstanceId;
    protected Map<String, Object> variables;
    protected Map<String, Object> localVariables;
    protected Map<String, Object> transientVariables;

    public AbstractNeedsPlanItemInstanceCmd(String planItemInstanceId) {
        this.planItemInstanceId = planItemInstanceId;
    }

    public AbstractNeedsPlanItemInstanceCmd(String planItemInstanceId, Map<String, Object> variables, Map<String, Object> localVariables, Map<String, Object> transientVariables) {
        this.planItemInstanceId = planItemInstanceId;
        this.variables = variables;
        this.localVariables = localVariables;
        this.transientVariables = transientVariables;
    }

    public Void execute(CommandContext commandContext) {
        if (this.planItemInstanceId == null) {
            throw new FlowableIllegalArgumentException("Plan item instance id is null");
        }
        PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findById(this.planItemInstanceId);
        if (planItemInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("Cannot find plan item instance for id " + this.planItemInstanceId, PlanItemInstanceEntity.class);
        }
        if (this.variables != null) {
            planItemInstanceEntity.setVariables(this.variables);
        }
        if (this.localVariables != null) {
            planItemInstanceEntity.setVariablesLocal(this.localVariables);
        }
        if (this.transientVariables != null) {
            planItemInstanceEntity.setTransientVariables(this.transientVariables);
        }
        this.internalExecute(commandContext, planItemInstanceEntity);
        return null;
    }

    protected abstract void internalExecute(CommandContext var1, PlanItemInstanceEntity var2);

    public String getPlanItemInstanceId() {
        return this.planItemInstanceId;
    }

    public void setPlanItemInstanceId(String planItemInstanceId) {
        this.planItemInstanceId = planItemInstanceId;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public Map<String, Object> getTransientVariables() {
        return this.transientVariables;
    }

    public void setTransientVariables(Map<String, Object> transientVariables) {
        this.transientVariables = transientVariables;
    }
}

