/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.impl.ChildTaskActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.process.ProcessInstanceService;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.EntityLinkUtil;
import org.flowable.cmmn.model.IOParameter;
import org.flowable.cmmn.model.Process;
import org.flowable.cmmn.model.ProcessTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessTaskActivityBehavior
extends ChildTaskActivityBehavior
implements PlanItemActivityBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessTaskActivityBehavior.class);
    protected Process process;
    protected Expression processRefExpression;
    protected String processRef;
    protected Boolean fallbackToDefaultTenant;

    public ProcessTaskActivityBehavior(Process process, Expression processRefExpression, ProcessTask processTask) {
        super(processTask.isBlocking(), processTask.getBlockingExpression(), processTask.getInParameters(), processTask.getOutParameters());
        this.process = process;
        this.processRefExpression = processRefExpression;
        this.processRef = processTask.getProcessRef();
        this.fallbackToDefaultTenant = processTask.getFallbackToDefaultTenant();
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, Map<String, Object> variables) {
        boolean blocking;
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        ProcessInstanceService processInstanceService = cmmnEngineConfiguration.getProcessInstanceService();
        if (processInstanceService == null) {
            throw new FlowableException("Could not start process instance: no " + ProcessInstanceService.class + " implementation found");
        }
        String externalRef = null;
        if (this.process != null) {
            externalRef = this.process.getExternalRef();
        } else if (this.processRefExpression != null) {
            externalRef = this.processRefExpression.getValue((VariableContainer)planItemInstanceEntity).toString();
        } else if (this.processRef != null) {
            externalRef = this.processRef;
        }
        if (StringUtils.isEmpty((CharSequence)externalRef)) {
            throw new FlowableException("Could not start process instance: no externalRef defined");
        }
        HashMap<String, Object> inParametersMap = new HashMap<String, Object>();
        this.handleInParameters(planItemInstanceEntity, cmmnEngineConfiguration, inParametersMap, cmmnEngineConfiguration.getExpressionManager());
        if (variables != null && !variables.isEmpty()) {
            inParametersMap.putAll(variables);
        }
        String processInstanceId = processInstanceService.generateNewProcessInstanceId();
        planItemInstanceEntity.setReferenceType("cmmn-1.1-to-bpmn-2.0-child-process");
        planItemInstanceEntity.setReferenceId(processInstanceId);
        if (CommandContextUtil.getCmmnEngineConfiguration(commandContext).isEnableEntityLinks()) {
            EntityLinkUtil.copyExistingEntityLinks(planItemInstanceEntity.getCaseInstanceId(), processInstanceId, "bpmn");
            EntityLinkUtil.createNewEntityLink(planItemInstanceEntity.getCaseInstanceId(), processInstanceId, "bpmn");
        }
        if (blocking = this.evaluateIsBlocking(planItemInstanceEntity)) {
            processInstanceService.startProcessInstanceByKey(externalRef, processInstanceId, planItemInstanceEntity.getId(), planItemInstanceEntity.getTenantId(), this.fallbackToDefaultTenant, inParametersMap);
        } else {
            processInstanceService.startProcessInstanceByKey(externalRef, processInstanceId, planItemInstanceEntity.getTenantId(), this.fallbackToDefaultTenant, inParametersMap);
        }
        if (!blocking) {
            CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
        }
    }

    @Override
    public void trigger(CommandContext commandContext, PlanItemInstanceEntity planItemInstance) {
        if (!"active".equals(planItemInstance.getState())) {
            throw new FlowableException("Can only trigger a plan item that is in the ACTIVE state");
        }
        if (planItemInstance.getReferenceId() == null) {
            throw new FlowableException("Cannot trigger process task plan item instance : no reference id set");
        }
        if (!"cmmn-1.1-to-bpmn-2.0-child-process".equals(planItemInstance.getReferenceType())) {
            throw new FlowableException("Cannot trigger process task plan item instance : reference type '" + planItemInstance.getReferenceType() + "' not supported");
        }
        CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstance);
        this.deleteProcessInstance(commandContext, planItemInstance);
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
        if ("active".equals(planItemInstance.getState())) {
            if ("terminate".equals(transition) || "exit".equals(transition)) {
                this.deleteProcessInstance(commandContext, planItemInstance);
            } else if ("complete".equals(transition)) {
                CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
                CaseInstanceEntity caseInstance = (CaseInstanceEntity)cmmnEngineConfiguration.getCaseInstanceEntityManager().findById(planItemInstance.getCaseInstanceId());
                this.handleOutParameters(planItemInstance, caseInstance, cmmnEngineConfiguration.getProcessInstanceService());
            }
        }
    }

    protected void deleteProcessInstance(CommandContext commandContext, DelegatePlanItemInstance planItemInstance) {
        ProcessInstanceService processInstanceService = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getProcessInstanceService();
        processInstanceService.deleteProcessInstance(planItemInstance.getReferenceId());
    }

    @Override
    public void deleteChildEntity(CommandContext commandContext, DelegatePlanItemInstance delegatePlanItemInstance, boolean cascade) {
        if (!"cmmn-1.1-to-bpmn-2.0-child-process".equals(delegatePlanItemInstance.getReferenceType())) {
            throw new FlowableException("Can only delete a child entity for a plan item with callback type cmmn-1.1-to-bpmn-2.0-child-process");
        }
        delegatePlanItemInstance.setState("terminated");
        this.deleteProcessInstance(commandContext, delegatePlanItemInstance);
    }

    protected void handleOutParameters(DelegatePlanItemInstance planItemInstance, CaseInstanceEntity caseInstance, ProcessInstanceService processInstanceService) {
        if (this.outParameters == null) {
            return;
        }
        for (IOParameter outParameter : this.outParameters) {
            String variableName = null;
            if (StringUtils.isNotEmpty((CharSequence)outParameter.getTarget())) {
                variableName = outParameter.getTarget();
            } else if (StringUtils.isNotEmpty((CharSequence)outParameter.getTargetExpression())) {
                Object variableNameValue = processInstanceService.resolveExpression(planItemInstance.getReferenceId(), outParameter.getTargetExpression());
                if (variableNameValue != null) {
                    variableName = variableNameValue.toString();
                } else {
                    LOGGER.warn("Out parameter target expression {} did not resolve to a variable name, this is most likely a programmatic error", (Object)outParameter.getTargetExpression());
                }
            }
            Object variableValue = null;
            if (StringUtils.isNotEmpty((CharSequence)outParameter.getSourceExpression())) {
                variableValue = processInstanceService.resolveExpression(planItemInstance.getReferenceId(), outParameter.getSourceExpression());
            } else if (StringUtils.isNotEmpty((CharSequence)outParameter.getSource())) {
                variableValue = processInstanceService.getVariable(planItemInstance.getReferenceId(), outParameter.getSource());
            }
            caseInstance.setVariable(variableName, variableValue);
        }
    }
}

