/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangePlanItemInstanceStateOperation;
import org.flowable.cmmn.engine.impl.behavior.CmmnActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class StartPlanItemInstanceOperation
extends AbstractChangePlanItemInstanceStateOperation {
    protected String entryCriterionId;

    public StartPlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId) {
        super(commandContext, planItemInstanceEntity);
        this.entryCriterionId = entryCriterionId;
    }

    @Override
    protected String getNewState() {
        return "active";
    }

    @Override
    protected String getLifeCycleTransition() {
        return "start";
    }

    @Override
    protected void internalExecute() {
        this.removeSentryRelatedData();
        this.planItemInstanceEntity.setEntryCriterionId(this.entryCriterionId);
        this.planItemInstanceEntity.setLastStartedTime(this.getCurrentTime(this.commandContext));
        CommandContextUtil.getCmmnHistoryManager(this.commandContext).recordPlanItemInstanceStarted(this.planItemInstanceEntity);
        this.executeActivityBehavior();
    }

    protected void executeActivityBehavior() {
        CmmnActivityBehavior activityBehavior = (CmmnActivityBehavior)this.planItemInstanceEntity.getPlanItem().getBehavior();
        if (activityBehavior instanceof CoreCmmnActivityBehavior) {
            ((CoreCmmnActivityBehavior)activityBehavior).execute(this.commandContext, this.planItemInstanceEntity);
        } else {
            activityBehavior.execute(this.planItemInstanceEntity);
        }
    }
}

