/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cdi.impl.event;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Date;
import javax.enterprise.inject.spi.BeanManager;
import org.flowable.cdi.BusinessProcessEvent;
import org.flowable.cdi.BusinessProcessEventType;
import org.flowable.cdi.annotation.event.BusinessProcessLiteral;
import org.flowable.cdi.annotation.event.EndActivityLiteral;
import org.flowable.cdi.annotation.event.StartActivityLiteral;
import org.flowable.cdi.annotation.event.TakeTransitionLiteral;
import org.flowable.cdi.impl.event.CdiBusinessProcessEvent;
import org.flowable.cdi.impl.util.BeanManagerLookup;
import org.flowable.cdi.impl.util.ProgrammaticBeanLookup;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.ExecutionListener;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.variable.api.delegate.VariableScope;

public class CdiExecutionListener
implements ExecutionListener,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final BusinessProcessEventType type;
    protected final String transitionName;
    protected final String activityId;

    public CdiExecutionListener(String transitionName) {
        this.type = BusinessProcessEventType.TAKE;
        this.transitionName = transitionName;
        this.activityId = null;
    }

    public CdiExecutionListener(String activityId, BusinessProcessEventType type) {
        this.type = type;
        this.transitionName = null;
        this.activityId = activityId;
    }

    public void notify(DelegateExecution execution) {
        try {
            ProgrammaticBeanLookup.lookup(ProcessEngine.class);
        }
        catch (Exception e) {
            return;
        }
        BusinessProcessEvent event = this.createEvent(execution);
        Annotation[] qualifiers = this.getQualifiers(event);
        this.getBeanManager().fireEvent((Object)event, qualifiers);
    }

    protected BusinessProcessEvent createEvent(DelegateExecution execution) {
        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition((String)execution.getProcessDefinitionId());
        ProcessEngineConfigurationImpl engineConfiguration = Context.getProcessEngineConfiguration();
        Date now = engineConfiguration.getClock().getCurrentTime();
        return new CdiBusinessProcessEvent(this.activityId, this.transitionName, processDefinition, (VariableScope)execution, this.type, execution.getProcessInstanceId(), execution.getId(), now);
    }

    protected BeanManager getBeanManager() {
        BeanManager bm = BeanManagerLookup.getBeanManager();
        if (bm == null) {
            throw new FlowableException("No cdi bean manager available, cannot publish event.");
        }
        return bm;
    }

    protected Annotation[] getQualifiers(BusinessProcessEvent event) {
        BusinessProcessLiteral businessProcessQualifier = new BusinessProcessLiteral(event.getProcessDefinition().getKey());
        if (this.type == BusinessProcessEventType.TAKE) {
            return new Annotation[]{businessProcessQualifier, new TakeTransitionLiteral(this.transitionName)};
        }
        if (this.type == BusinessProcessEventType.START_ACTIVITY) {
            return new Annotation[]{businessProcessQualifier, new StartActivityLiteral(this.activityId)};
        }
        if (this.type == BusinessProcessEventType.END_ACTIVITY) {
            return new Annotation[]{businessProcessQualifier, new EndActivityLiteral(this.activityId)};
        }
        return new Annotation[0];
    }
}

