/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;

public class ExtensionElement
extends BaseElement {
    protected String name;
    protected String namespacePrefix;
    protected String namespace;
    protected String elementText;
    protected Map<String, List<ExtensionElement>> childElements = new LinkedHashMap<String, List<ExtensionElement>>();

    public String getElementText() {
        return this.elementText;
    }

    public void setElementText(String elementText) {
        this.elementText = elementText;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Map<String, List<ExtensionElement>> getChildElements() {
        return this.childElements;
    }

    public void addChildElement(ExtensionElement childElement) {
        if (childElement != null && StringUtils.isNotEmpty((CharSequence)childElement.getName())) {
            ArrayList elementList = null;
            if (!this.childElements.containsKey(childElement.getName())) {
                elementList = new ArrayList();
                this.childElements.put(childElement.getName(), elementList);
            }
            this.childElements.get(childElement.getName()).add(childElement);
        }
    }

    public void setChildElements(Map<String, List<ExtensionElement>> childElements) {
        this.childElements = childElements;
    }

    @Override
    public ExtensionElement clone() {
        ExtensionElement clone = new ExtensionElement();
        clone.setValues(this);
        return clone;
    }

    public void setValues(ExtensionElement otherElement) {
        this.setName(otherElement.getName());
        this.setNamespacePrefix(otherElement.getNamespacePrefix());
        this.setNamespace(otherElement.getNamespace());
        this.setElementText(otherElement.getElementText());
        this.setAttributes(otherElement.getAttributes());
        this.childElements = new LinkedHashMap<String, List<ExtensionElement>>();
        if (otherElement.getChildElements() != null && !otherElement.getChildElements().isEmpty()) {
            for (String key : otherElement.getChildElements().keySet()) {
                List<ExtensionElement> otherElementList = otherElement.getChildElements().get(key);
                if (otherElementList == null || otherElementList.isEmpty()) continue;
                ArrayList<ExtensionElement> elementList = new ArrayList<ExtensionElement>();
                for (ExtensionElement extensionElement : otherElementList) {
                    elementList.add(extensionElement.clone());
                }
                this.childElements.put(key, elementList);
            }
        }
    }
}

