/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.test.impl;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.api.repository.AppDeploymentBuilder;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.test.AppDeployment;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.test.EnsureCleanDbUtils;
import org.junit.Ignore;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppTestRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppTestRunner.class);
    protected static AppEngineConfiguration appEngineConfiguration;
    protected static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK;

    public AppTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public static AppEngineConfiguration getAppEngineConfiguration() {
        return appEngineConfiguration;
    }

    public static void setAppEngineConfiguration(AppEngineConfiguration appEngineConfiguration) {
        AppTestRunner.appEngineConfiguration = appEngineConfiguration;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        String deploymentId = null;
        if (method.getAnnotation(Ignore.class) == null && method.getAnnotation(AppDeployment.class) != null) {
            deploymentId = this.deployAppDefinition(method);
        }
        super.runChild(method, notifier);
        if (deploymentId != null) {
            this.deleteDeployment(deploymentId);
        }
        this.assertDatabaseEmpty(method);
    }

    protected String deployAppDefinition(FrameworkMethod method) {
        try {
            LOGGER.debug("annotation @AppDeployment creates deployment for {}.{}", (Object)method.getMethod().getDeclaringClass().getSimpleName(), (Object)method.getName());
            if (appEngineConfiguration == null) {
                throw new FlowableException("No cached App engine found.");
            }
            AppRepositoryService repositoryService = appEngineConfiguration.getAppRepositoryService();
            AppDeploymentBuilder deploymentBuilder = repositoryService.createDeployment().name(method.getMethod().getDeclaringClass().getSimpleName() + "." + method.getName());
            AppDeployment deploymentAnnotation = (AppDeployment)method.getAnnotation(AppDeployment.class);
            String[] resources = deploymentAnnotation.resources();
            if (resources.length == 0) {
                resources = new String[]{this.getAppDefinitionResource(method)};
            }
            for (String resource : resources) {
                deploymentBuilder.addClasspathResource(resource);
            }
            if (StringUtils.isNotEmpty((CharSequence)deploymentAnnotation.tenantId())) {
                deploymentBuilder.tenantId(deploymentAnnotation.tenantId());
            }
            return deploymentBuilder.deploy().getId();
        }
        catch (Exception e) {
            LOGGER.error("Error while deploying app definition", (Throwable)e);
            return null;
        }
    }

    protected String getAppDefinitionResource(FrameworkMethod method) {
        String className = method.getMethod().getDeclaringClass().getName().replace('.', '/');
        String methodName = method.getName();
        String resource = className + "." + methodName + ".app";
        return resource;
    }

    protected void deleteDeployment(String deploymentId) {
        appEngineConfiguration.getAppRepositoryService().deleteDeployment(deploymentId, true);
    }

    protected void assertDatabaseEmpty(FrameworkMethod method) {
        EnsureCleanDbUtils.assertAndEnsureCleanDb((String)(this.getTestClass().getName() + "." + method.getName()), (Logger)LOGGER, (AbstractEngineConfiguration)appEngineConfiguration, TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK, (boolean)true, null);
    }

    static {
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = Arrays.asList("ACT_GE_PROPERTY", "ACT_ID_PROPERTY", "ACT_APP_DATABASECHANGELOG", "ACT_APP_DATABASECHANGELOGLOCK", "ACT_CMMN_DATABASECHANGELOG", "ACT_CMMN_DATABASECHANGELOGLOCK", "ACT_FO_DATABASECHANGELOG", "ACT_FO_DATABASECHANGELOGLOCK", "FLW_EV_DATABASECHANGELOG", "FLW_EV_DATABASECHANGELOGLOCK");
    }
}

