/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.deployer;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.flowable.app.api.repository.AppModel;
import org.flowable.app.api.repository.AppResourceConverter;
import org.flowable.app.engine.impl.deployer.BaseAppModel;
import org.flowable.common.engine.api.FlowableException;

public class AppResourceConverterImpl
implements AppResourceConverter {
    protected ObjectMapper objectMapper;

    public AppResourceConverterImpl(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public AppModel convertAppResourceToModel(byte[] appResourceBytes) {
        try {
            return (AppModel)this.objectMapper.readValue(appResourceBytes, BaseAppModel.class);
        }
        catch (Exception e) {
            throw new FlowableException("Error reading app resource", (Throwable)e);
        }
    }

    public String convertAppModelToJson(AppModel appModel) {
        try {
            return this.objectMapper.writeValueAsString((Object)appModel);
        }
        catch (Exception e) {
            throw new FlowableException("Error writing app model to json", (Throwable)e);
        }
    }
}

