/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.db;

import java.sql.Connection;
import java.sql.SQLException;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.db.DbSchemaManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppDbSchemaManager
implements DbSchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppDbSchemaManager.class);
    public static final String LIQUIBASE_CHANGELOG = "org/flowable/app/db/liquibase/flowable-app-db-changelog.xml";

    public void initSchema() {
        this.initSchema(CommandContextUtil.getAppEngineConfiguration());
    }

    public void initSchema(AppEngineConfiguration appEngineConfiguration) {
        this.initSchema(appEngineConfiguration, appEngineConfiguration.getDatabaseSchemaUpdate());
    }

    public void initSchema(AppEngineConfiguration appEngineConfiguration, String databaseSchemaUpdate) {
        try {
            if ("create-drop".equals(databaseSchemaUpdate)) {
                this.dbSchemaCreate();
            } else if ("drop-create".equals(databaseSchemaUpdate)) {
                this.dbSchemaDrop();
                this.dbSchemaCreate();
            } else if ("true".equals(databaseSchemaUpdate)) {
                this.dbSchemaUpdate();
            } else if ("false".equals(databaseSchemaUpdate)) {
                Liquibase liquibase = this.createLiquibaseInstance(appEngineConfiguration);
                liquibase.validate();
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error initialising app data model", (Throwable)e);
        }
    }

    protected Liquibase createLiquibaseInstance(AppEngineConfiguration appEngineConfiguration) throws SQLException, DatabaseException, LiquibaseException {
        String databaseCatalog;
        Connection jdbcConnection = null;
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        jdbcConnection = commandContext == null ? appEngineConfiguration.getDataSource().getConnection() : CommandContextUtil.getDbSqlSession(commandContext).getSqlSession().getConnection();
        if (!jdbcConnection.getAutoCommit()) {
            jdbcConnection.commit();
        }
        JdbcConnection connection = new JdbcConnection(jdbcConnection);
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
        database.setDatabaseChangeLogTableName("ACT_APP_" + database.getDatabaseChangeLogTableName());
        database.setDatabaseChangeLogLockTableName("ACT_APP_" + database.getDatabaseChangeLogLockTableName());
        String databaseSchema = appEngineConfiguration.getDatabaseSchema();
        if (StringUtils.isNotEmpty((CharSequence)databaseSchema)) {
            database.setDefaultSchemaName(databaseSchema);
            database.setLiquibaseSchemaName(databaseSchema);
        }
        if (StringUtils.isNotEmpty((CharSequence)(databaseCatalog = appEngineConfiguration.getDatabaseCatalog()))) {
            database.setDefaultCatalogName(databaseCatalog);
            database.setLiquibaseCatalogName(databaseCatalog);
        }
        return this.createLiquibaseInstance(database);
    }

    public Liquibase createLiquibaseInstance(Database database) throws LiquibaseException {
        return new Liquibase(LIQUIBASE_CHANGELOG, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
    }

    public void dbSchemaCreate() {
        try {
            this.getCommonDbSchemaManager().dbSchemaCreate();
            this.getIdentityLinkDbSchemaManager().dbSchemaCreate();
            this.getVariableDbSchemaManager().dbSchemaCreate();
            Liquibase liquibase = this.createLiquibaseInstance(CommandContextUtil.getAppEngineConfiguration());
            liquibase.update("app");
        }
        catch (Exception e) {
            throw new FlowableException("Error creating App engine tables", (Throwable)e);
        }
    }

    public void dbSchemaDrop() {
        try {
            Liquibase liquibase = this.createLiquibaseInstance(CommandContextUtil.getAppEngineConfiguration());
            liquibase.dropAll();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping App engine tables", (Throwable)e);
        }
        try {
            this.getVariableDbSchemaManager().dbSchemaDrop();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping variable tables", (Throwable)e);
        }
        try {
            this.getIdentityLinkDbSchemaManager().dbSchemaDrop();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping identity link tables", (Throwable)e);
        }
        try {
            this.getCommonDbSchemaManager().dbSchemaDrop();
        }
        catch (Exception e) {
            LOGGER.info("Error dropping common tables", (Throwable)e);
        }
    }

    public String dbSchemaUpdate() {
        try {
            this.getCommonDbSchemaManager().dbSchemaUpdate();
            if (CommandContextUtil.getAppEngineConfiguration().isExecuteServiceDbSchemaManagers()) {
                this.getIdentityLinkDbSchemaManager().dbSchemaUpdate();
                this.getVariableDbSchemaManager().dbSchemaUpdate();
            }
            Liquibase liquibase = this.createLiquibaseInstance(CommandContextUtil.getAppEngineConfiguration());
            liquibase.update("cmmn");
        }
        catch (Exception e) {
            throw new FlowableException("Error updating App engine tables", (Throwable)e);
        }
        return null;
    }

    protected DbSchemaManager getCommonDbSchemaManager() {
        return CommandContextUtil.getAppEngineConfiguration().getCommonDbSchemaManager();
    }

    protected DbSchemaManager getIdentityLinkDbSchemaManager() {
        return CommandContextUtil.getAppEngineConfiguration().getIdentityLinkDbSchemaManager();
    }

    protected DbSchemaManager getVariableDbSchemaManager() {
        return CommandContextUtil.getAppEngineConfiguration().getVariableDbSchemaManager();
    }
}

