/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.rest;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.entity.ContentType;
import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.api.repository.AppDeployment;
import org.flowable.app.rest.AppRestUrlBuilder;
import org.flowable.app.rest.AppRestUrls;
import org.flowable.app.rest.service.api.repository.AppDefinitionResponse;
import org.flowable.app.rest.service.api.repository.AppDeploymentResourceResponse;
import org.flowable.app.rest.service.api.repository.AppDeploymentResponse;
import org.flowable.common.rest.resolver.ContentTypeResolver;

public class AppRestResponseFactory {
    public AppDefinitionResponse createAppDefinitionResponse(AppDefinition appDefinition) {
        return this.createAppDefinitionResponse(appDefinition, this.createUrlBuilder());
    }

    public AppDefinitionResponse createAppDefinitionResponse(AppDefinition appDefinition, AppRestUrlBuilder urlBuilder) {
        AppDefinitionResponse response = new AppDefinitionResponse(appDefinition);
        response.setUrl(urlBuilder.buildUrl(AppRestUrls.URL_APP_DEFINITION, appDefinition.getId()));
        return response;
    }

    public List<AppDefinitionResponse> createAppDefinitionResponseList(List<AppDefinition> appDefinitions) {
        AppRestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<AppDefinitionResponse> responseList = new ArrayList<AppDefinitionResponse>(appDefinitions.size());
        for (AppDefinition appDefinition : appDefinitions) {
            responseList.add(this.createAppDefinitionResponse(appDefinition, urlBuilder));
        }
        return responseList;
    }

    public List<AppDeploymentResponse> createAppDeploymentResponseList(List<AppDeployment> deployments) {
        AppRestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<AppDeploymentResponse> responseList = new ArrayList<AppDeploymentResponse>(deployments.size());
        for (AppDeployment deployment : deployments) {
            responseList.add(this.createAppDeploymentResponse(deployment, urlBuilder));
        }
        return responseList;
    }

    public AppDeploymentResponse createAppDeploymentResponse(AppDeployment deployment) {
        return this.createAppDeploymentResponse(deployment, this.createUrlBuilder());
    }

    public AppDeploymentResponse createAppDeploymentResponse(AppDeployment deployment, AppRestUrlBuilder urlBuilder) {
        return new AppDeploymentResponse(deployment, urlBuilder.buildUrl(AppRestUrls.URL_DEPLOYMENT, deployment.getId()));
    }

    public List<AppDeploymentResourceResponse> createDeploymentResourceResponseList(String deploymentId, List<String> resourceList, ContentTypeResolver contentTypeResolver) {
        AppRestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<AppDeploymentResourceResponse> responseList = new ArrayList<AppDeploymentResourceResponse>(resourceList.size());
        for (String resourceId : resourceList) {
            String contentType = null;
            contentType = resourceId.toLowerCase().endsWith(".app") ? ContentType.APPLICATION_JSON.getMimeType() : contentTypeResolver.resolveContentType(resourceId);
            responseList.add(this.createDeploymentResourceResponse(deploymentId, resourceId, contentType, urlBuilder));
        }
        return responseList;
    }

    public AppDeploymentResourceResponse createDeploymentResourceResponse(String deploymentId, String resourceId, String contentType) {
        return this.createDeploymentResourceResponse(deploymentId, resourceId, contentType, this.createUrlBuilder());
    }

    public AppDeploymentResourceResponse createDeploymentResourceResponse(String deploymentId, String resourceId, String contentType, AppRestUrlBuilder urlBuilder) {
        String resourceUrl = urlBuilder.buildUrl(AppRestUrls.URL_DEPLOYMENT_RESOURCE, deploymentId, resourceId);
        String resourceContentUrl = urlBuilder.buildUrl(AppRestUrls.URL_DEPLOYMENT_RESOURCE_CONTENT, deploymentId, resourceId);
        String type = "resource";
        if (resourceId.endsWith(".app")) {
            type = "appDefinition";
        }
        return new AppDeploymentResourceResponse(resourceId, resourceUrl, resourceContentUrl, contentType, type);
    }

    protected AppRestUrlBuilder createUrlBuilder() {
        return AppRestUrlBuilder.fromCurrentRequest();
    }
}

