/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.utils;

import java.lang.reflect.Field;
import java.security.Security;
import java.util.Arrays;
import java.util.List;

public class SystemInformation {
    private static final String sdkVersion = "2.9.1";
    public static final String connectionFaqIssueUrl = "https://github.com/FISCO-BCOS/java-sdk/issues/536";
    public static final String connectionFaqDocUrl = "https://fisco-bcos-documentation.readthedocs.io/zh_CN/latest/docs/faq/connect.html";
    public static final String nettyVersion = "4.1.53.Final";
    public static final InformationProperty JAVA_VERSION;
    public static final InformationProperty JDK_DISABLED_NAMED_CURVES;
    public static final InformationProperty JDK_DISABLE_NATIVE_OPTION;
    public static final InformationProperty OS_NAME;
    public static final InformationProperty OS_ARCH;
    public static final InformationProperty OS_VERSION;
    public static final InformationProperty JVM_VERSION;
    public static final InformationProperty JAVA_VENDOR;
    public static final InformationProperty JAVA_VENDOR_URL;
    private static String systemInformation;
    public static List<String> EXPECTED_CURVES;
    public static boolean supportSecp256K1;

    public static String getSystemInformation() {
        return systemInformation;
    }

    static {
        Field[] fields;
        JAVA_VERSION = new InformationProperty("Java Version", System.getProperty("java.version"));
        JDK_DISABLED_NAMED_CURVES = new InformationProperty("JDK Disabled NamedCurves", System.getProperty("jdk.disabled.namedCurves"));
        JDK_DISABLE_NATIVE_OPTION = new InformationProperty("JDK DisableNative Option", System.getProperty("jdk.sunec.disableNative"));
        OS_NAME = new InformationProperty("OS Name", System.getProperty("os.name"));
        OS_ARCH = new InformationProperty("OS Arch", System.getProperty("os.arch"));
        OS_VERSION = new InformationProperty("OS Version", System.getProperty("os.version"));
        JVM_VERSION = new InformationProperty("JVM Version", System.getProperty("java.vm.version"));
        JAVA_VENDOR = new InformationProperty("JVM Vendor", System.getProperty("java.vendor"));
        JAVA_VENDOR_URL = new InformationProperty("JVM Vendor URL", System.getProperty("java.vendor.url"));
        EXPECTED_CURVES = Arrays.asList("secp256k1");
        supportSecp256K1 = false;
        systemInformation = systemInformation + "--------- System Information --------- \n";
        systemInformation = "* FISCO BCOS Java SDK Version: 2.9.1\n";
        String supportedCurves = Security.getProviders("AlgorithmParameters.EC")[0].getService("AlgorithmParameters", "EC").getAttribute("SupportedCurves");
        if (supportedCurves.contains("secp256k1")) {
            supportSecp256K1 = true;
        }
        for (String curve : EXPECTED_CURVES) {
            if (supportedCurves.contains(curve)) {
                systemInformation = systemInformation + "* Support " + curve + " : true\n";
                continue;
            }
            systemInformation = systemInformation + "* Support " + curve + " : false\n";
        }
        for (Field field : fields = SystemInformation.class.getDeclaredFields()) {
            if (!field.getType().equals(InformationProperty.class)) continue;
            try {
                InformationProperty property = (InformationProperty)field.get(null);
                systemInformation = systemInformation + "* " + property.getKey() + " : " + property.getValue() + "\n";
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    public static class InformationProperty {
        private String key;
        private String value;

        public InformationProperty(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

