/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.fisco.bcos.sdk.utils.Hex;
import org.fisco.bcos.sdk.utils.StringUtils;
import org.fisco.bcos.sdk.utils.exceptions.MessageDecodingException;
import org.fisco.bcos.sdk.utils.exceptions.MessageEncodingException;

public final class Numeric {
    private static final String HEX_PREFIX = "0x";

    private Numeric() {
    }

    public static String encodeQuantity(BigInteger value) {
        if (value.signum() != -1) {
            return HEX_PREFIX + value.toString(16);
        }
        throw new MessageEncodingException("Negative values are not supported");
    }

    public static BigInteger decodeQuantity(String value) {
        if (!Numeric.isValidHexQuantity(value)) {
            try {
                if (value == null) {
                    return new BigInteger("0");
                }
                return new BigInteger(value);
            }
            catch (NumberFormatException e) {
                throw new MessageDecodingException("Negative ", e);
            }
        }
        try {
            return new BigInteger(value.substring(2), 16);
        }
        catch (NumberFormatException e) {
            throw new MessageDecodingException("value is not a hex number or a decimal number");
        }
    }

    private static boolean isValidHexQuantity(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() < 3) {
            return false;
        }
        return value.startsWith(HEX_PREFIX);
    }

    public static String cleanHexPrefix(String input) {
        if (Numeric.containsHexPrefix(input)) {
            return input.substring(2);
        }
        return input;
    }

    public static String prependHexPrefix(String input) {
        if (!Numeric.containsHexPrefix(input)) {
            return HEX_PREFIX + input;
        }
        return input;
    }

    public static boolean containsHexPrefix(String input) {
        return !StringUtils.isEmpty(input) && input.length() > 1 && input.charAt(0) == '0' && input.charAt(1) == 'x';
    }

    public static BigInteger toBigInt(byte[] value, int offset, int length) {
        return Numeric.toBigInt(Arrays.copyOfRange(value, offset, offset + length));
    }

    public static BigInteger toBigInt(byte[] value) {
        return new BigInteger(1, value);
    }

    public static BigInteger toBigInt(String hexValue) {
        String cleanValue = Numeric.cleanHexPrefix(hexValue);
        return Numeric.toBigIntNoPrefix(cleanValue);
    }

    public static BigInteger toBigIntNoPrefix(String hexValue) {
        return new BigInteger(hexValue, 16);
    }

    public static String toHexStringWithPrefix(BigInteger value) {
        return HEX_PREFIX + value.toString(16);
    }

    public static String toHexStringNoPrefix(byte[] input) {
        return Hex.toHexString(input);
    }

    public static String toHexStringNoPrefix(BigInteger value) {
        return value.toString(16);
    }

    public static String toHexStringWithPrefixZeroPadded(BigInteger value, int size) {
        return Numeric.toHexStringZeroPadded(value, size, true);
    }

    public static String toHexStringWithPrefixSafe(BigInteger value) {
        String result = Numeric.toHexStringNoPrefix(value);
        if (result.length() < 2) {
            result = StringUtils.zeros(1) + result;
        }
        return HEX_PREFIX + result;
    }

    public static String toHexStringNoPrefixZeroPadded(BigInteger value, int size) {
        return Numeric.toHexStringZeroPadded(value, size, false);
    }

    private static String toHexStringZeroPadded(BigInteger value, int size, boolean withPrefix) {
        String result = Numeric.toHexStringNoPrefix(value);
        int length = result.length();
        if (length > size) {
            throw new UnsupportedOperationException("Value " + result + "is larger then length " + size);
        }
        if (value.signum() < 0) {
            throw new UnsupportedOperationException("Value cannot be negative");
        }
        if (length < size) {
            result = StringUtils.zeros(size - length) + result;
        }
        if (withPrefix) {
            return HEX_PREFIX + result;
        }
        return result;
    }

    public static byte[] toBytesPadded(BigInteger value, int length) {
        int srcOffset;
        int bytesLength;
        byte[] result = new byte[length];
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            bytesLength = bytes.length - 1;
            srcOffset = 1;
        } else {
            bytesLength = bytes.length;
            srcOffset = 0;
        }
        if (bytesLength > length) {
            throw new RuntimeException("Input is too large to put in byte array of size " + length);
        }
        int destOffset = length - bytesLength;
        System.arraycopy(bytes, srcOffset, result, destOffset, bytesLength);
        return result;
    }

    public static byte[] hexStringToByteArray(String input) {
        int startIdx;
        byte[] data;
        String cleanInput = Numeric.cleanHexPrefix(input);
        int len = cleanInput.length();
        if (len == 0) {
            return new byte[0];
        }
        if (len % 2 != 0) {
            data = new byte[len / 2 + 1];
            data[0] = (byte)Character.digit(cleanInput.charAt(0), 16);
            startIdx = 1;
        } else {
            data = new byte[len / 2];
            startIdx = 0;
        }
        for (int i = startIdx; i < len; i += 2) {
            data[(i + 1) / 2] = (byte)((Character.digit(cleanInput.charAt(i), 16) << 4) + Character.digit(cleanInput.charAt(i + 1), 16));
        }
        return data;
    }

    public static String toHexString(byte[] input, int offset, int length, boolean withPrefix) {
        return withPrefix ? Numeric.toHexString(Arrays.copyOfRange(input, offset, offset + length)) : Numeric.toHexStringNoPrefix(Arrays.copyOfRange(input, offset, offset + length));
    }

    public static String toHexString(byte[] input) {
        StringBuilder stringBuilder = new StringBuilder(2 + input.length * 2);
        stringBuilder.append(HEX_PREFIX).append(Hex.toHexString(input));
        return stringBuilder.toString();
    }

    public static byte asByte(int m, int n) {
        return (byte)(m << 4 | n);
    }

    public static boolean isIntegerValue(BigDecimal value) {
        return value.signum() == 0 || value.scale() <= 0 || value.stripTrailingZeros().scale() <= 0;
    }

    public static String getKeyNoPrefix(String prefix, String keyStr, int keyLengthInHex) {
        String keyNoPrefix = Numeric.cleanHexPrefix(keyStr);
        if (keyNoPrefix.startsWith(prefix) && keyNoPrefix.length() == keyLengthInHex + prefix.length()) {
            keyNoPrefix = keyNoPrefix.substring(prefix.length());
        }
        if (keyNoPrefix.length() < keyLengthInHex) {
            keyNoPrefix = StringUtils.zeros(keyLengthInHex - keyNoPrefix.length()) + keyNoPrefix;
        }
        return keyNoPrefix;
    }

    public static String getHexKeyWithPrefix(String hexPublicKey, String requiredPrefix, int requiredKeyLengthInHex) {
        String keyWithPrefix = Numeric.cleanHexPrefix(hexPublicKey);
        if (keyWithPrefix.length() < requiredKeyLengthInHex) {
            keyWithPrefix = StringUtils.zeros(requiredKeyLengthInHex - keyWithPrefix.length()) + keyWithPrefix;
        }
        if (!keyWithPrefix.startsWith(requiredPrefix)) {
            keyWithPrefix = requiredPrefix + keyWithPrefix;
        }
        return keyWithPrefix;
    }
}

