/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.model;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.fisco.bcos.sdk.model.RetCode;
import org.fisco.bcos.sdk.utils.Numeric;

public class TransactionReceiptStatus {
    public static final RetCode Success;
    public static final RetCode Unknown;
    public static final RetCode BadRLP;
    public static final RetCode InvalidFormat;
    public static final RetCode OutOfGasIntrinsic;
    public static final RetCode InvalidSignature;
    public static final RetCode InvalidNonce;
    public static final RetCode NotEnoughCash;
    public static final RetCode OutOfGasBase;
    public static final RetCode BlockGasLimitReached;
    public static final RetCode BadInstruction;
    public static final RetCode BadJumpDestination;
    public static final RetCode OutOfGas;
    public static final RetCode OutOfStack;
    public static final RetCode StackUnderflow;
    public static final RetCode NonceCheckFail;
    public static final RetCode BlockLimitCheckFail;
    public static final RetCode FilterCheckFail;
    public static final RetCode NoDeployPermission;
    public static final RetCode NoCallPermission;
    public static final RetCode NoTxPermission;
    public static final RetCode PrecompiledError;
    public static final RetCode RevertInstruction;
    public static final RetCode InvalidZeroSignatureFormat;
    public static final RetCode AddressAlreadyUsed;
    public static final RetCode PermissionDenied;
    public static final RetCode CallAddressError;
    public static final RetCode GasOverflow;
    public static final RetCode TxPoolIsFull;
    public static final RetCode TransactionRefused;
    public static final RetCode ContractFrozen;
    public static final RetCode AccountFrozen;
    public static final RetCode NotEnoughRemainGas;
    public static final RetCode AlreadyKnown;
    public static final RetCode AlreadyInChain;
    public static final RetCode InvalidChainId;
    public static final RetCode InvalidGroupId;
    public static final RetCode RequestNotBelongToTheGroup;
    public static final RetCode MalformedTx;
    public static final RetCode OverGroupMemoryLimit;
    public static final RetCode TimeOut;
    protected static Map<Integer, RetCode> codeToRetCode;

    public static RetCode getStatusMessage(String status, String message) {
        int statusCode = Numeric.decodeQuantity(status).intValue();
        if (codeToRetCode.containsKey(statusCode)) {
            return codeToRetCode.get(statusCode);
        }
        return new RetCode(statusCode, message);
    }

    static {
        Field[] fields;
        Success = new RetCode(0, "Success");
        Unknown = new RetCode(1, "Unknown");
        BadRLP = new RetCode(2, "Bad RLP");
        InvalidFormat = new RetCode(3, "Invalid format");
        OutOfGasIntrinsic = new RetCode(4, "The contract to deploy is too long(or input data is too long)");
        InvalidSignature = new RetCode(5, "Invalid signature");
        InvalidNonce = new RetCode(6, "Invalid nonce");
        NotEnoughCash = new RetCode(7, "Not enough cash");
        OutOfGasBase = new RetCode(8, "Input data is too long");
        BlockGasLimitReached = new RetCode(9, "Block gas limit reached");
        BadInstruction = new RetCode(10, "Bad instruction");
        BadJumpDestination = new RetCode(11, "Bad jump destination");
        OutOfGas = new RetCode(12, "Out-of-gas during EVM execution");
        OutOfStack = new RetCode(13, "Out of stack");
        StackUnderflow = new RetCode(14, "Stack underflow");
        NonceCheckFail = new RetCode(15, "Nonce check fail");
        BlockLimitCheckFail = new RetCode(16, "Block limit check fail");
        FilterCheckFail = new RetCode(17, "Filter check fail");
        NoDeployPermission = new RetCode(18, "No deploy permission");
        NoCallPermission = new RetCode(19, "No call permission");
        NoTxPermission = new RetCode(20, "No tx permission");
        PrecompiledError = new RetCode(21, "Precompiled error");
        RevertInstruction = new RetCode(22, "Revert instruction");
        InvalidZeroSignatureFormat = new RetCode(23, "Invalid zero signature format");
        AddressAlreadyUsed = new RetCode(24, "Address already used");
        PermissionDenied = new RetCode(25, "Permission denied");
        CallAddressError = new RetCode(26, "Call address error");
        GasOverflow = new RetCode(27, "Gas overflow");
        TxPoolIsFull = new RetCode(28, "Transaction pool is full");
        TransactionRefused = new RetCode(29, "Transaction refused");
        ContractFrozen = new RetCode(30, "The contract has been frozen");
        AccountFrozen = new RetCode(31, "The account has been frozen");
        NotEnoughRemainGas = new RetCode(32, "The remain gas of the account is less than the required gas");
        AlreadyKnown = new RetCode(10000, "Transaction already known");
        AlreadyInChain = new RetCode(10001, "Transaction already in chain");
        InvalidChainId = new RetCode(10002, "Invalid chain id");
        InvalidGroupId = new RetCode(10003, "Invalid group id");
        RequestNotBelongToTheGroup = new RetCode(10004, "The request doesn't belong to the group");
        MalformedTx = new RetCode(10005, "Malformed transaction");
        OverGroupMemoryLimit = new RetCode(10006, "Exceeded the group transaction pool capacity limit");
        TimeOut = new RetCode(50001, "Transaction receipt timeout");
        codeToRetCode = new HashMap<Integer, RetCode>();
        for (Field field : fields = TransactionReceiptStatus.class.getDeclaredFields()) {
            if (!field.getType().equals(RetCode.class)) continue;
            try {
                RetCode constantRetCode = (RetCode)field.get(null);
                codeToRetCode.put(constantRetCode.getCode(), constantRetCode);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }
}

