/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.model;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.UnsupportedEncodingException;
import org.fisco.bcos.sdk.model.Message;

public class AmopMsg
extends Message {
    private static final long serialVersionUID = -7276897518418560354L;
    private String topic;

    public AmopMsg() {
        this.result = 0;
    }

    public AmopMsg(Message msg) {
        this.length = msg.getLength();
        this.type = msg.getType();
        this.seq = msg.getSeq();
        this.result = msg.getResult();
    }

    public void decodeAmopBody(byte[] in) {
        ByteBuf amopBody = Unpooled.wrappedBuffer((byte[])in);
        if (this.result == 0) {
            Short topicLength = amopBody.readUnsignedByte();
            byte[] topicBytes = new byte[topicLength - 1];
            amopBody.readBytes(topicBytes, 0, topicLength - 1);
            this.topic = new String(topicBytes);
            this.data = new byte[in.length - topicLength];
            amopBody.readBytes(this.data, 0, in.length - topicLength);
        }
    }

    public Message getMessage() {
        Message msg = new Message();
        msg.setResult(this.result);
        msg.setType(this.type);
        msg.setSeq(this.seq);
        byte[] msgData = new byte[this.length - 42 + 1 + this.topic.getBytes().length];
        ByteBuf out = Unpooled.buffer();
        this.writeExtra(out);
        out.readBytes(msgData, 0, this.length - 42 + 1 + this.topic.getBytes().length);
        msg.setData(msgData);
        return msg;
    }

    @Override
    public void encode(ByteBuf encodedData) {
        this.writeHeader(encodedData);
        this.writeExtra(encodedData);
    }

    @Override
    public void writeHeader(ByteBuf out) {
        try {
            this.length = 43 + this.topic.getBytes("utf-8").length + this.data.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(" topic string to utf8 failed, topic: " + this.topic);
        }
        super.writeHeader(out);
    }

    public void writeExtra(ByteBuf out) {
        try {
            out.writeByte(1 + this.topic.getBytes("utf-8").length);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(" topic string to utf8 failed, topic: " + this.topic);
        }
        out.writeBytes(this.topic.getBytes());
        out.writeBytes(this.data);
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String toTopic) {
        this.topic = toTopic;
    }
}

