/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.crypto.vrf;

import org.fisco.bcos.sdk.crypto.vrf.Curve25519VRF;
import org.fisco.bcos.sdk.crypto.vrf.VRFException;
import org.fisco.bcos.sdk.crypto.vrf.VRFInterface;
import org.fisco.bcos.sdk.utils.Numeric;

public class VRFKeyPair {
    private String vrfPublicKey;
    private String vrfPrivateKey;
    private VRFInterface vrfInterface;

    private VRFKeyPair() {
    }

    public VRFKeyPair(String vrfPrivateKey, String vrfPublicKey) {
        this.vrfPrivateKey = Numeric.getKeyNoPrefix("04", vrfPrivateKey, 64);
        this.vrfPublicKey = vrfPublicKey;
    }

    public VRFKeyPair(int vrfCryptoType, String vrfPrivateKey) {
        if (vrfCryptoType != 1000) {
            throw new VRFException("Invalid cryptoType, only support CryptoType.ED25519_VRF_TYPE = 1000 now!");
        }
        this.vrfInterface = new Curve25519VRF();
        this.vrfPrivateKey = Numeric.getKeyNoPrefix("04", vrfPrivateKey, 64);
        this.vrfPublicKey = this.vrfInterface.getPublicKeyFromPrivateKey(vrfPrivateKey);
    }

    public String getVrfPublicKey() {
        return this.vrfPublicKey;
    }

    public void setVrfPublicKey(String vrfPublicKey) {
        this.vrfPublicKey = vrfPublicKey;
    }

    public String getVrfPrivateKey() {
        return this.vrfPrivateKey;
    }

    public void setVrfPrivateKey(String vrfPrivateKey) {
        this.vrfPrivateKey = vrfPrivateKey;
    }
}

