/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.crypto.signature;

import java.util.ArrayList;
import java.util.List;
import org.fisco.bcos.sdk.crypto.exceptions.SignatureException;
import org.fisco.bcos.sdk.crypto.signature.SignatureResult;
import org.fisco.bcos.sdk.rlp.RlpString;
import org.fisco.bcos.sdk.rlp.RlpType;
import org.fisco.bcos.sdk.utils.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECDSASignatureResult
extends SignatureResult {
    protected static Logger logger = LoggerFactory.getLogger(SignatureResult.class);
    protected byte v;
    protected static int VBASE = 27;

    public ECDSASignatureResult(byte v, byte[] r, byte[] s) {
        super(r, s);
        this.v = v;
    }

    public ECDSASignatureResult(String signatureResult) {
        super(signatureResult);
        if (this.signatureBytes.length != 65) {
            throw new SignatureException("Invalid signature for invalid length " + this.signatureBytes.length);
        }
        this.v = this.signatureBytes[64];
    }

    @Override
    public String convertToString() {
        byte[] SignatureBytes = new byte[65];
        System.arraycopy(this.r, 0, SignatureBytes, 0, 32);
        System.arraycopy(this.s, 0, SignatureBytes, 32, 32);
        SignatureBytes[64] = this.v;
        return Hex.toHexString(SignatureBytes);
    }

    @Override
    public List<RlpType> encode() {
        ArrayList<RlpType> encodeResult = new ArrayList<RlpType>();
        int encodedV = this.v + VBASE;
        encodeResult.add(RlpString.create((byte)encodedV));
        super.encodeCommonField(encodeResult);
        return encodeResult;
    }

    public byte getV() {
        return this.v;
    }

    public void setV(byte v) {
        this.v = v;
    }
}

