/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.crypto.keypair;

import com.webank.blockchain.hsm.crypto.sdf.AlgorithmType;
import com.webank.blockchain.hsm.crypto.sdf.SDF;
import com.webank.blockchain.hsm.crypto.sdf.SDFCryptoResult;
import com.webank.wedpr.crypto.CryptoResult;
import java.math.BigInteger;
import java.security.KeyPair;
import org.fisco.bcos.sdk.crypto.exceptions.KeyPairException;
import org.fisco.bcos.sdk.crypto.exceptions.SignatureException;
import org.fisco.bcos.sdk.crypto.hash.Hash;
import org.fisco.bcos.sdk.crypto.hash.SDFSM3Hash;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.crypto.keystore.KeyTool;
import org.fisco.bcos.sdk.utils.Hex;
import org.fisco.bcos.sdk.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDFSM2KeyPair
extends CryptoKeyPair {
    protected static Logger logger = LoggerFactory.getLogger(SDFSM2KeyPair.class);
    public static Hash DefaultHashAlgorithm = new SDFSM3Hash();
    public long keyIndex;
    public String password;
    public boolean isInternalKey = false;

    public SDFSM2KeyPair() {
        this.initSM2KeyPairObject();
        CryptoKeyPair keyPair = this.generateKeyPair();
        this.hexPrivateKey = keyPair.getHexPrivateKey();
        this.hexPublicKey = keyPair.getHexPublicKey();
        this.keyPair = KeyTool.convertHexedStringToKeyPair(this.hexPrivateKey, this.curveName);
    }

    public SDFSM2KeyPair(KeyPair javaKeyPair) {
        super(javaKeyPair);
        this.initSM2KeyPairObject();
    }

    protected SDFSM2KeyPair(CryptoResult result) {
        super(result);
        this.initSM2KeyPairObject();
        this.keyPair = KeyTool.convertHexedStringToKeyPair(this.hexPrivateKey, this.curveName);
    }

    protected SDFSM2KeyPair(long keyIndex, String password) {
        this.initSM2KeyPairObject();
        this.keyIndex = keyIndex;
        this.password = password;
        SDFCryptoResult pkResult = SDF.ExportInternalPublicKey((long)((keyIndex + 1L) / 2L), (AlgorithmType)AlgorithmType.SM2);
        if (pkResult.getSdfErrorMessage() != null && !pkResult.getSdfErrorMessage().equals("")) {
            throw new KeyPairException("get sdf sm2 internal key public key failed:" + pkResult.getSdfErrorMessage());
        }
        this.hexPublicKey = SDFSM2KeyPair.getPublicKeyNoPrefix(pkResult.getPublicKey());
        this.isInternalKey = true;
    }

    private void initSM2KeyPairObject() {
        this.keyStoreSubDir = "gm";
        this.hashImpl = new SDFSM3Hash();
        this.curveName = "sm2p256v1";
        this.signatureAlgorithm = "1.2.156.10197.1.501";
    }

    @Override
    public CryptoKeyPair generateKeyPair() {
        SDFCryptoResult sdfResult = SDF.KeyGen((AlgorithmType)AlgorithmType.SM2);
        SDFSM2KeyPair.checkSDFCryptoResult(sdfResult);
        CryptoResult result = new CryptoResult();
        result.privateKey = sdfResult.getPrivateKey();
        result.publicKey = Numeric.getHexKeyWithPrefix(sdfResult.getPublicKey(), "04", 128);
        return new SDFSM2KeyPair(result);
    }

    public static void checkSDFCryptoResult(SDFCryptoResult result) {
        if (result.getSdfErrorMessage() != null && !result.getSdfErrorMessage().isEmpty()) {
            throw new SignatureException("Sign with sdf sm2 failed:" + result.getSdfErrorMessage());
        }
    }

    @Override
    public CryptoKeyPair createKeyPair(KeyPair keyPair) {
        return new SDFSM2KeyPair(keyPair);
    }

    public SDFSM2KeyPair createKeyPair(long keyIndex, String password) {
        return new SDFSM2KeyPair(keyIndex, password);
    }

    public boolean isInternalKey() {
        return this.isInternalKey;
    }

    public long getKeyIndex() {
        return this.keyIndex;
    }

    public String getPassword() {
        return this.password;
    }

    public static String getAddressByPublicKey(String publicKey) {
        return SDFSM2KeyPair.getAddress(publicKey, DefaultHashAlgorithm);
    }

    public static byte[] getAddressByPublicKey(byte[] publicKey) {
        return Hex.decode(Numeric.cleanHexPrefix(SDFSM2KeyPair.getAddressByPublicKey(Hex.toHexString(publicKey))));
    }

    public static byte[] getAddressByPublicKey(BigInteger publicKey) {
        byte[] publicKeyBytes = Numeric.toBytesPadded(publicKey, 64);
        return SDFSM2KeyPair.getAddressByPublicKey(publicKeyBytes);
    }
}

