/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.contract.precompiled.crud;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fisco.bcos.sdk.abi.datatypes.generated.tuples.generated.Tuple2;
import org.fisco.bcos.sdk.channel.model.ChannelPrococolExceiption;
import org.fisco.bcos.sdk.channel.model.EnumNodeVersion;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.contract.precompiled.callback.PrecompiledCallback;
import org.fisco.bcos.sdk.contract.precompiled.crud.CRUD;
import org.fisco.bcos.sdk.contract.precompiled.crud.common.Condition;
import org.fisco.bcos.sdk.contract.precompiled.crud.common.Entry;
import org.fisco.bcos.sdk.contract.precompiled.crud.table.TableFactory;
import org.fisco.bcos.sdk.contract.precompiled.model.PrecompiledVersionCheck;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.model.NodeVersion;
import org.fisco.bcos.sdk.model.RetCode;
import org.fisco.bcos.sdk.model.TransactionReceipt;
import org.fisco.bcos.sdk.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.transaction.codec.decode.ReceiptParser;
import org.fisco.bcos.sdk.transaction.model.exception.ContractException;
import org.fisco.bcos.sdk.utils.ObjectMapperFactory;
import org.fisco.bcos.sdk.utils.StringUtils;

public class TableCRUDService {
    private final Client client;
    private final CRUD crudService;
    private final TableFactory tableFactory;
    private static final String ValueFieldsDelimiter = ",";
    private final String currentVersion;

    public TableCRUDService(Client client, CryptoKeyPair credential) {
        this.client = client;
        this.crudService = CRUD.load("0x0000000000000000000000000000000000001002", client, credential);
        this.tableFactory = TableFactory.load("0x0000000000000000000000000000000000001001", client, credential);
        this.currentVersion = client.getClientNodeVersion().getNodeVersion().getSupportedVersion();
    }

    public static String convertValueFieldsToString(List<String> valueFields) {
        return StringUtils.join(valueFields, ValueFieldsDelimiter);
    }

    public void checkKey(String key) throws ContractException {
        if (key.length() > 255) {
            throw new ContractException("The length of the table key exceeds the maximum limit 255");
        }
    }

    public RetCode createTable(String tableName, String keyFieldName, List<String> valueFields) throws ContractException {
        PrecompiledVersionCheck.TABLE_CRUD_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        this.checkKey(keyFieldName);
        String valueFieldsString = TableCRUDService.convertValueFieldsToString(valueFields);
        return ReceiptParser.parseTransactionReceipt(this.tableFactory.createTable(tableName, keyFieldName, valueFieldsString));
    }

    public RetCode insert(String tableName, String key, Entry fieldNameToValue) throws ContractException {
        PrecompiledVersionCheck.TABLE_CRUD_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        this.checkKey(key);
        try {
            String fieldNameToValueStr = ObjectMapperFactory.getObjectMapper().writeValueAsString(fieldNameToValue.getFieldNameToValue());
            return ReceiptParser.parseTransactionReceipt(this.crudService.insert(tableName, key, fieldNameToValueStr, ""));
        }
        catch (JsonProcessingException e) {
            throw new ContractException("insert " + fieldNameToValue.toString() + " to " + tableName + " failed, error info:" + e.getMessage(), e);
        }
    }

    public RetCode update(String tableName, String key, Entry fieldNameToValue, Condition condition) throws ContractException {
        PrecompiledVersionCheck.TABLE_CRUD_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        this.checkKey(key);
        try {
            String fieldNameToValueStr = ObjectMapperFactory.getObjectMapper().writeValueAsString(fieldNameToValue.getFieldNameToValue());
            String conditionStr = this.encodeCondition(condition);
            return ReceiptParser.parseTransactionReceipt(this.crudService.update(tableName, key, fieldNameToValueStr, conditionStr, ""));
        }
        catch (JsonProcessingException e) {
            throw new ContractException("update " + fieldNameToValue.toString() + " to " + tableName + " failed, error info:" + e.getMessage(), e);
        }
    }

    private String encodeCondition(Condition condition) throws JsonProcessingException {
        if (condition == null) {
            condition = new Condition();
        }
        return ObjectMapperFactory.getObjectMapper().writeValueAsString(condition.getConditions());
    }

    public RetCode remove(String tableName, String key, Condition condition) throws ContractException {
        PrecompiledVersionCheck.TABLE_CRUD_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        this.checkKey(key);
        try {
            String conditionStr = this.encodeCondition(condition);
            return ReceiptParser.parseTransactionReceipt(this.crudService.remove(tableName, key, conditionStr, ""));
        }
        catch (JsonProcessingException e) {
            throw new ContractException("remove " + key + " with condition from " + tableName + " failed");
        }
    }

    public List<Map<String, String>> select(String tableName, String key, Condition condition) throws ContractException {
        PrecompiledVersionCheck.TABLE_CRUD_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        this.checkKey(key);
        try {
            String conditionStr = this.encodeCondition(condition);
            return TableCRUDService.parseSelectResult(this.crudService.select(tableName, key, conditionStr, ""));
        }
        catch (ContractException e) {
            throw ReceiptParser.parseExceptionCall(e);
        }
        catch (JsonProcessingException e) {
            throw new ContractException("select " + key + " with condition from " + tableName + " failed, error info:" + e.getMessage(), e);
        }
    }

    public static List<Map<String, String>> parseSelectResult(String selectResult) throws JsonProcessingException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        return (List)objectMapper.readValue(selectResult, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, Map.class));
    }

    private List<Map<String, String>> getTableDescLessThan230Version(EnumNodeVersion.Version enumNodeVersion, String tableName) throws ContractException {
        List<Object> tableDesc = new ArrayList();
        tableDesc = enumNodeVersion.getMajor() == 2 && enumNodeVersion.getMinor() < 2 ? this.select("_sys_tables_", "_user_" + tableName, new Condition()) : this.select("_sys_tables_", "u_" + tableName, new Condition());
        for (Map map : tableDesc) {
            if (!map.containsKey("table_name")) continue;
            map.remove("table_name");
        }
        return tableDesc;
    }

    private List<Map<String, String>> getTableDesc(String tableName) throws ContractException {
        Tuple2<String, String> tableDesc = this.crudService.desc(tableName);
        ArrayList<Map<String, String>> tableDescList = new ArrayList<Map<String, String>>(1);
        HashMap<String, String> keyToValue = new HashMap<String, String>();
        keyToValue.put("key_field", tableDesc.getValue1());
        keyToValue.put("value_field", tableDesc.getValue2());
        tableDescList.add(0, keyToValue);
        return tableDescList;
    }

    public List<Map<String, String>> desc(String tableName) throws ContractException {
        PrecompiledVersionCheck.TABLE_CRUD_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        try {
            NodeVersion nodeVersion = this.client.getClientNodeVersion();
            EnumNodeVersion.Version enumNodeVersion = EnumNodeVersion.getClassVersion(nodeVersion.getNodeVersion().getSupportedVersion());
            if (enumNodeVersion.getMajor() == 2 && enumNodeVersion.getMinor() <= 3) {
                return this.getTableDescLessThan230Version(enumNodeVersion, tableName);
            }
            return this.getTableDesc(tableName);
        }
        catch (ChannelPrococolExceiption e) {
            throw new ContractException("Obtain description for " + tableName + " failed, error info: " + e.getMessage(), e);
        }
        catch (ContractException e) {
            throw ReceiptParser.parseExceptionCall(e);
        }
    }

    private TransactionCallback createTransactionCallback(final PrecompiledCallback callback) {
        return new TransactionCallback(){

            @Override
            public void onResponse(TransactionReceipt receipt) {
                RetCode retCode = null;
                try {
                    retCode = ReceiptParser.parseTransactionReceipt(receipt);
                }
                catch (ContractException e) {
                    retCode.setCode(e.getErrorCode());
                    retCode.setMessage(e.getMessage());
                    retCode.setTransactionReceipt(receipt);
                }
                callback.onResponse(retCode);
            }
        };
    }

    public void asyncInsert(String tableName, String key, Entry fieldNameToValue, PrecompiledCallback callback) throws ContractException {
        PrecompiledVersionCheck.TABLE_CRUD_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        this.checkKey(key);
        try {
            String fieldNameToValueStr = ObjectMapperFactory.getObjectMapper().writeValueAsString(fieldNameToValue.getFieldNameToValue());
            this.crudService.insert(tableName, key, fieldNameToValueStr, "", this.createTransactionCallback(callback));
        }
        catch (JsonProcessingException e) {
            throw new ContractException("asyncInsert " + fieldNameToValue.toString() + " to " + tableName + " failed, error info:" + e.getMessage(), e);
        }
    }

    public void asyncUpdate(String tableName, String key, Entry fieldNameToValue, Condition condition, PrecompiledCallback callback) throws ContractException {
        PrecompiledVersionCheck.TABLE_CRUD_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        this.checkKey(key);
        try {
            String fieldNameToValueStr = ObjectMapperFactory.getObjectMapper().writeValueAsString(fieldNameToValue.getFieldNameToValue());
            String conditionStr = this.encodeCondition(condition);
            this.crudService.update(tableName, key, fieldNameToValueStr, conditionStr, "", this.createTransactionCallback(callback));
        }
        catch (JsonProcessingException e) {
            throw new ContractException("asyncUpdate " + fieldNameToValue.toString() + " to " + tableName + " failed, error info:" + e.getMessage(), e);
        }
    }

    public void asyncRemove(String tableName, String key, Condition condition, PrecompiledCallback callback) throws ContractException {
        PrecompiledVersionCheck.TABLE_CRUD_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        this.checkKey(key);
        try {
            this.crudService.remove(tableName, key, this.encodeCondition(condition), "", this.createTransactionCallback(callback));
        }
        catch (JsonProcessingException e) {
            throw new ContractException("asyncRemove " + key + " with condition from " + tableName + " failed");
        }
    }
}

