/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.config.model;

import java.util.Map;
import org.fisco.bcos.sdk.config.model.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolConfig {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolConfig.class);
    public static String DEFAULT_MAX_BLOCKING_QUEUE_SIZE = "102400";
    private Integer channelProcessorThreadSize;
    private Integer receiptProcessorThreadSize;
    private Integer maxBlockingQueueSize;

    public ThreadPoolConfig(ConfigProperty configProperty) {
        Map<String, Object> threadPoolConfig = configProperty.getThreadPool();
        String cpuNum = String.valueOf(Runtime.getRuntime().availableProcessors());
        String channelProcessorThread = ConfigProperty.getValue(threadPoolConfig, "channelProcessorThreadSize", cpuNum);
        String receiptProcessorThread = ConfigProperty.getValue(threadPoolConfig, "receiptProcessorThreadSize", cpuNum);
        this.channelProcessorThreadSize = Integer.valueOf(channelProcessorThread);
        this.receiptProcessorThreadSize = Integer.valueOf(receiptProcessorThread);
        if (this.channelProcessorThreadSize <= 0) {
            this.channelProcessorThreadSize = Runtime.getRuntime().availableProcessors();
        }
        if (this.receiptProcessorThreadSize <= 0) {
            this.receiptProcessorThreadSize = Runtime.getRuntime().availableProcessors();
        }
        this.maxBlockingQueueSize = Integer.valueOf(ConfigProperty.getValue(threadPoolConfig, "maxBlockingQueueSize", DEFAULT_MAX_BLOCKING_QUEUE_SIZE));
        if (this.maxBlockingQueueSize <= 0) {
            this.maxBlockingQueueSize = Integer.valueOf(DEFAULT_MAX_BLOCKING_QUEUE_SIZE);
        }
        logger.debug("Init ThreadPoolConfig, channelProcessorThreadSize: {}, receiptProcessorThreadSize: {}, maxBlockingQueueSize: {}", new Object[]{this.channelProcessorThreadSize, this.receiptProcessorThreadSize, this.maxBlockingQueueSize});
    }

    public Integer getChannelProcessorThreadSize() {
        return this.channelProcessorThreadSize;
    }

    public void setChannelProcessorThreadSize(Integer channelProcessorThreadSize) {
        this.channelProcessorThreadSize = channelProcessorThreadSize;
    }

    public Integer getReceiptProcessorThreadSize() {
        return this.receiptProcessorThreadSize;
    }

    public void setReceiptProcessorThreadSize(Integer receiptProcessorThreadSize) {
        this.receiptProcessorThreadSize = receiptProcessorThreadSize;
    }

    public Integer getMaxBlockingQueueSize() {
        return this.maxBlockingQueueSize;
    }

    public void setMaxBlockingQueueSize(Integer maxBlockingQueueSize) {
        this.maxBlockingQueueSize = maxBlockingQueueSize;
    }
}

