/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.config.model;

import java.util.Map;
import java.util.Objects;
import org.fisco.bcos.sdk.config.exceptions.ConfigException;
import org.fisco.bcos.sdk.config.model.ConfigProperty;

public class AccountConfig {
    private String keyStoreDir;
    private String accountAddress;
    private String accountFileFormat;
    private String accountPassword;
    private String accountFilePath;
    private String accountKeyIndex;

    public AccountConfig(ConfigProperty configProperty) throws ConfigException {
        this.keyStoreDir = ConfigProperty.getConfigFilePath(ConfigProperty.getValue(configProperty.getAccount(), "keyStoreDir", "account"));
        this.accountAddress = ConfigProperty.getValue(configProperty.getAccount(), "accountAddress", "");
        this.accountFileFormat = ConfigProperty.getValue(configProperty.getAccount(), "accountFileFormat", "pem");
        this.accountPassword = ConfigProperty.getValue(configProperty.getAccount(), "password", "");
        this.accountFilePath = ConfigProperty.getValue(configProperty.getAccount(), "accountFilePath", "");
        this.accountKeyIndex = ConfigProperty.getValue(configProperty.getAccount(), "accountKeyIndex", "");
        if (!this.accountFilePath.equals("")) {
            this.accountFilePath = ConfigProperty.getConfigFilePath(this.accountFilePath);
        }
        this.checkAccountConfig(configProperty);
    }

    private void checkAccountConfig(ConfigProperty configProperty) throws ConfigException {
        Map<String, Object> cryptoMaterial = configProperty.getCryptoMaterial();
        String cryptoType = "ssm";
        if (cryptoMaterial != null) {
            cryptoType = ConfigProperty.getValue(cryptoMaterial, "cryptoProvider", "ssm");
        }
        if (cryptoType.equalsIgnoreCase("hsm")) {
            if (this.accountKeyIndex == null) {
                throw new ConfigException("load account failed, you are using hardware secure moduele(HSM), please config accountKeyIndex.");
            }
            return;
        }
        if (this.accountAddress.equals("")) {
            return;
        }
        if ("pem".compareToIgnoreCase(this.accountFileFormat) != 0 && "p12".compareToIgnoreCase(this.accountFileFormat) != 0) {
            throw new ConfigException("load account failed, only support pem and p12 account file format, current configurated account file format is " + this.accountFileFormat);
        }
    }

    public String getAccountFilePath() {
        return this.accountFilePath;
    }

    public void setAccountFilePath(String accountFilePath) {
        this.accountFilePath = accountFilePath;
    }

    public String getKeyStoreDir() {
        return this.keyStoreDir;
    }

    public void setKeyStoreDir(String keyStoreDir) {
        this.keyStoreDir = keyStoreDir;
    }

    public String getAccountAddress() {
        return this.accountAddress;
    }

    public void setAccountAddress(String accountAddress) {
        this.accountAddress = accountAddress;
    }

    public String getAccountFileFormat() {
        return this.accountFileFormat;
    }

    public void setAccountFileFormat(String accountFileFormat) {
        this.accountFileFormat = accountFileFormat;
    }

    public String getAccountPassword() {
        return this.accountPassword;
    }

    public void setAccountPassword(String accountPassword) {
        this.accountPassword = accountPassword;
    }

    public String getAccountKeyIndex() {
        return this.accountKeyIndex;
    }

    public void setAccountKeyIndex(String accountKeyIndex) {
        this.accountKeyIndex = accountKeyIndex;
    }

    public String toString() {
        return "AccountConfig{keyStoreDir='" + this.keyStoreDir + '\'' + ", accountAddress='" + this.accountAddress + '\'' + ", accountFileFormat='" + this.accountFileFormat + '\'' + ", accountPassword='" + this.accountPassword + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountConfig that = (AccountConfig)o;
        return Objects.equals(this.keyStoreDir, that.keyStoreDir) && Objects.equals(this.accountAddress, that.accountAddress) && Objects.equals(this.accountFileFormat, that.accountFileFormat) && Objects.equals(this.accountPassword, that.accountPassword);
    }

    public int hashCode() {
        return Objects.hash(this.keyStoreDir, this.accountAddress, this.accountFileFormat, this.accountPassword);
    }

    public void clearAccount() {
        this.accountFilePath = "";
        this.accountAddress = "";
        this.accountPassword = "";
    }

    public boolean isAccountConfigured() {
        if (this.accountFilePath != null && !this.accountFilePath.equals("")) {
            return true;
        }
        return this.accountAddress != null && !this.accountAddress.equals("");
    }
}

