/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.client.protocol.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.fisco.bcos.sdk.client.exceptions.ClientException;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.crypto.signature.ECDSASignatureResult;
import org.fisco.bcos.sdk.crypto.signature.SM2SignatureResult;
import org.fisco.bcos.sdk.crypto.signature.SignatureResult;
import org.fisco.bcos.sdk.rlp.RlpEncoder;
import org.fisco.bcos.sdk.rlp.RlpList;
import org.fisco.bcos.sdk.rlp.RlpString;
import org.fisco.bcos.sdk.rlp.RlpType;
import org.fisco.bcos.sdk.utils.Hex;
import org.fisco.bcos.sdk.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTransactionResponse {
    private static Logger logger = LoggerFactory.getLogger(JsonTransactionResponse.class);
    private String blockHash;
    private String blockNumber;
    private String from;
    private String gas;
    private String hash;
    private String input;
    private String nonce;
    private String to;
    private String transactionIndex;
    private String value;
    private String gasPrice;
    private String blockLimit;
    private String chainId;
    private String groupId;
    private String extraData;
    private SignatureResponse signature;

    public String getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public BigInteger getBlockNumber() {
        return Numeric.decodeQuantity(this.blockNumber);
    }

    public void setBlockNumber(String blockNumber) {
        this.blockNumber = blockNumber;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getGas() {
        return this.gas;
    }

    public void setGas(String gas) {
        this.gas = gas;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getTransactionIndex() {
        return this.transactionIndex;
    }

    public void setTransactionIndex(String transactionIndex) {
        this.transactionIndex = transactionIndex;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
    }

    public String getBlockLimit() {
        return this.blockLimit;
    }

    public void setBlockLimit(String blockLimit) {
        this.blockLimit = blockLimit;
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public SignatureResponse getSignature() {
        return this.signature;
    }

    public void setSignature(SignatureResponse signature) {
        this.signature = signature;
    }

    private List<RlpType> encodeTransactionResponse(CryptoSuite cryptoSuite) throws ClientException {
        if (this.blockLimit == null || this.chainId == null || this.groupId == null || this.extraData == null || this.signature == null) {
            throw new ClientException("calculate hash for the transaction failed for missing fields! Please make sure FISCO BCOS version >= v2.7.0");
        }
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        result.add(RlpString.create(Numeric.decodeQuantity(this.nonce)));
        result.add(RlpString.create(Numeric.decodeQuantity(this.gasPrice)));
        result.add(RlpString.create(Numeric.decodeQuantity(this.gas)));
        result.add(RlpString.create(Numeric.decodeQuantity(this.blockLimit)));
        BigInteger receiveAddressValue = Numeric.decodeQuantity(this.to);
        if (receiveAddressValue.equals(BigInteger.ZERO)) {
            result.add(RlpString.create(""));
        } else {
            result.add(RlpString.create(Numeric.hexStringToByteArray(this.to)));
        }
        result.add(RlpString.create(Numeric.decodeQuantity(this.value)));
        result.add(RlpString.create(Numeric.hexStringToByteArray(this.input)));
        result.add(RlpString.create(Numeric.decodeQuantity(this.chainId)));
        result.add(RlpString.create(Numeric.decodeQuantity(this.groupId)));
        if (this.extraData.equals("0x")) {
            result.add(RlpString.create(""));
        } else {
            result.add(RlpString.create(Numeric.hexStringToByteArray(this.extraData)));
        }
        int startIndex = 0;
        if (this.signature.getSignature().startsWith("0x")) {
            startIndex = 2;
        }
        SignatureResult signatureResult = cryptoSuite.getCryptoTypeConfig() == 0 ? new ECDSASignatureResult(this.signature.getSignature().substring(startIndex)) : new SM2SignatureResult(this.signature.getV(), this.signature.getSignature().substring(startIndex));
        result.addAll(((SignatureResult)signatureResult).encode());
        return result;
    }

    public String calculateHash(CryptoSuite cryptoSuite) throws ClientException {
        try {
            List<RlpType> encodedTransaction = this.encodeTransactionResponse(cryptoSuite);
            RlpList rlpList = new RlpList(encodedTransaction);
            return "0x" + Hex.toHexString(cryptoSuite.hash(RlpEncoder.encode(rlpList)));
        }
        catch (Exception e) {
            logger.warn("calculate hash for the transaction failed, blockHash: {}, blockNumber: {}, transactionHash: {}, error info: {}", new Object[]{this.blockHash, this.blockNumber, this.hash, e});
            throw new ClientException("calculate hash for transaction " + this.hash + " failed for " + e.getMessage(), e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonTransactionResponse that = (JsonTransactionResponse)o;
        return Objects.equals(this.blockHash, that.blockHash) && Objects.equals(Numeric.decodeQuantity(this.blockNumber), Numeric.decodeQuantity(that.blockNumber)) && Objects.equals(this.from, that.from) && Objects.equals(this.gas, that.gas) && Objects.equals(this.hash, that.hash) && Objects.equals(this.input, that.input) && Objects.equals(this.nonce, that.nonce) && Objects.equals(this.to, that.to) && Objects.equals(this.transactionIndex, that.transactionIndex) && Objects.equals(this.value, that.value) && Objects.equals(this.gasPrice, that.gasPrice) && Objects.equals(this.blockLimit, that.blockLimit) && Objects.equals(this.chainId, that.chainId) && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.extraData, that.extraData) && Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.blockHash, Numeric.decodeQuantity(this.blockNumber), this.from, this.gas, this.hash, this.input, this.nonce, this.to, this.transactionIndex, this.value, this.gasPrice, this.blockLimit, this.chainId, this.groupId, this.extraData, this.signature);
    }

    public String toString() {
        return "{blockHash='" + this.blockHash + '\'' + ", blockNumber='" + this.blockNumber + '\'' + ", from='" + this.from + '\'' + ", gas='" + this.gas + '\'' + ", hash='" + this.hash + '\'' + ", input='" + this.input + '\'' + ", nonce='" + this.nonce + '\'' + ", to='" + this.to + '\'' + ", transactionIndex='" + this.transactionIndex + '\'' + ", value='" + this.value + '\'' + ", gasPrice='" + this.gasPrice + '\'' + ", blockLimit='" + this.blockLimit + '\'' + ", chainId='" + this.chainId + '\'' + ", groupId='" + this.groupId + '\'' + ", extraData='" + this.extraData + '\'' + ", signature=" + this.signature + '}';
    }

    public static class SignatureResponse {
        private String r;
        private String s;
        private String v;
        private String signature;

        public String getR() {
            return this.r;
        }

        public void setR(String r) {
            this.r = r;
        }

        public String getS() {
            return this.s;
        }

        public void setS(String s) {
            this.s = s;
        }

        public String getV() {
            return this.v;
        }

        public void setV(String v) {
            this.v = v;
        }

        public String getSignature() {
            return this.signature;
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }

        public String toString() {
            return "{r='" + this.r + '\'' + ", s='" + this.s + '\'' + ", v='" + this.v + '\'' + ", signature='" + this.signature + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SignatureResponse that = (SignatureResponse)o;
            return Objects.equals(this.r, that.r) && Objects.equals(this.s, that.s) && Objects.equals(this.v, that.v) && Objects.equals(this.signature, that.signature);
        }

        public int hashCode() {
            return Objects.hash(this.r, this.s, this.v, this.signature);
        }
    }
}

